/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.bulk.selection.EmptyBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FolderFileShortcutBulkSelection;
import com.liferay.document.library.internal.bulk.selection.MultipleFileShortcutBulkSelection;
import com.liferay.document.library.internal.bulk.selection.SingleFileShortcutBulkSelection;
import com.liferay.document.library.internal.bulk.selection.util.BulkSelectionFactoryUtil;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFileShortcut"}, service={BulkSelectionFactory.class})
public class FileShortcutBulkSelectionFactory
implements BulkSelectionFactory<FileShortcut> {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private RepositoryProvider _repositoryProvider;

    public BulkSelection<FileShortcut> create(Map<String, String[]> parameterMap) {
        if (BulkSelectionFactoryUtil.isSelectAll(parameterMap)) {
            return new FolderFileShortcutBulkSelection(BulkSelectionFactoryUtil.getRepositoryId(parameterMap), BulkSelectionFactoryUtil.getFolderId(parameterMap), parameterMap, this._repositoryProvider, this._dlAppService);
        }
        if (!parameterMap.containsKey("rowIdsDLFileShortcut")) {
            return new EmptyBulkSelection();
        }
        String[] values = parameterMap.get("rowIdsDLFileShortcut");
        return this._getFileShortcutSelection(values, parameterMap);
    }

    private BulkSelection<FileShortcut> _getFileShortcutSelection(String[] values, Map<String, String[]> parameterMap) {
        long[] fileShortcutIds;
        if (values.length == 1) {
            values = StringUtil.split((String)values[0]);
        }
        if ((fileShortcutIds = GetterUtil.getLongValues((String[])values)).length == 1) {
            return new SingleFileShortcutBulkSelection(fileShortcutIds[0], parameterMap, this._dlAppService);
        }
        return new MultipleFileShortcutBulkSelection(fileShortcutIds, parameterMap, this._dlAppService);
    }
}

