/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal;

import com.liferay.document.library.internal.configuration.StoreAreaConfiguration;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.StoreAreaProcessor;
import com.liferay.petra.function.UnsafeConsumer;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.module.service.Snapshot;
import com.liferay.portal.kernel.scheduler.SchedulerJobConfiguration;
import com.liferay.portal.kernel.scheduler.TimeUnit;
import com.liferay.portal.kernel.scheduler.TriggerConfiguration;
import com.liferay.portal.kernel.service.CompanyLocalService;
import java.time.Duration;
import java.time.temporal.TemporalAmount;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.internal.configuration.StoreAreaConfiguration"}, service={SchedulerJobConfiguration.class})
public class CleanUpStoreAreasSchedulerJobConfiguration
implements SchedulerJobConfiguration {
    private static final Snapshot<StoreAreaProcessor> _storeAreaProcessorSnapshot = new Snapshot(CleanUpStoreAreasSchedulerJobConfiguration.class, StoreAreaProcessor.class, "(default=true)", true);
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;
    private Map<Long, String> _startOffsets;
    private StoreAreaConfiguration _storeAreaConfiguration;
    private TriggerConfiguration _triggerConfiguration;

    public UnsafeConsumer<Long, Exception> getCompanyJobExecutorUnsafeConsumer() {
        return this::_cleanUpStorageAreas;
    }

    public UnsafeRunnable<Exception> getJobExecutorUnsafeRunnable() {
        return () -> this._companyLocalService.forEachCompanyId(this::_cleanUpStorageAreas);
    }

    public TriggerConfiguration getTriggerConfiguration() {
        return this._triggerConfiguration;
    }

    @Activate
    protected void activate(Map<String, Object> properties) {
        this._storeAreaConfiguration = (StoreAreaConfiguration)ConfigurableUtil.createConfigurable(StoreAreaConfiguration.class, properties);
        this._triggerConfiguration = TriggerConfiguration.createTriggerConfiguration((int)this._storeAreaConfiguration.cleanUpInterval(), (TimeUnit)TimeUnit.DAY);
        this._startOffsets = new ConcurrentHashMap<Long, String>();
    }

    private void _cleanUpStorageAreas(long companyId) {
        StoreAreaProcessor storeAreaProcessor = (StoreAreaProcessor)_storeAreaProcessorSnapshot.get();
        if (storeAreaProcessor == null) {
            return;
        }
        this._startOffsets.put(companyId, storeAreaProcessor.cleanUpDeletedStoreArea(companyId, this._storeAreaConfiguration.evictionQuota(), name -> !this._isDLFileVersionReferenced(companyId, (String)name), this._startOffsets.getOrDefault(companyId, ""), (TemporalAmount)Duration.ofDays(this._storeAreaConfiguration.evictionAge())));
        this._startOffsets.put(companyId, storeAreaProcessor.cleanUpNewStoreArea(companyId, this._storeAreaConfiguration.evictionQuota(), name -> !this._isDLFileVersionReferenced(companyId, (String)name), this._startOffsets.getOrDefault(companyId, ""), (TemporalAmount)Duration.ofDays(this._storeAreaConfiguration.evictionAge())));
    }

    private boolean _isDLFileVersionReferenced(Long companyId, String name) {
        int pos = name.lastIndexOf("~");
        if (pos == -1) {
            return true;
        }
        int fileVersionsCount = this._dlFileVersionLocalService.getFileVersionsCount(companyId.longValue(), name.substring(pos + 1));
        return fileVersionsCount > 0;
    }
}

