/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.configuration.helper;

import com.liferay.document.library.internal.configuration.DLSizeLimitConfiguration;
import com.liferay.document.library.internal.util.MimeTypeSizeLimitUtil;
import com.liferay.petra.string.StringUtil;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.util.Validator;
import java.util.Dictionary;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPid={"com.liferay.document.library.internal.configuration.DLSizeLimitConfiguration"}, service={DLSizeLimitConfigurationHelper.class})
public class DLSizeLimitConfigurationHelper {
    private final Map<Long, DLSizeLimitConfiguration> _companyConfigurationBeans = new ConcurrentHashMap<Long, DLSizeLimitConfiguration>();
    private final Map<String, Long> _companyIds = new ConcurrentHashMap<String, Long>();
    private volatile Map<Long, Map<String, Long>> _companyMimeTypeSizeLimitsMap;
    private final Map<Long, DLSizeLimitConfiguration> _groupConfigurationBeans = new ConcurrentHashMap<Long, DLSizeLimitConfiguration>();
    private final Map<String, Long> _groupIds = new ConcurrentHashMap<String, Long>();
    @Reference
    private GroupLocalService _groupLocalService;
    private volatile Map<Long, Map<String, Long>> _groupMimeTypeSizeLimitsMap;
    private volatile DLSizeLimitConfiguration _systemDLSizeLimitConfiguration;

    public long getCompanyFileMaxSize(long companyId) {
        DLSizeLimitConfiguration dlSizeLimitConfiguration = this._getCompanyDLSizeLimitConfiguration(companyId);
        return dlSizeLimitConfiguration.fileMaxSize();
    }

    public long getCompanyMaxSizeToCopy(long companyId) {
        DLSizeLimitConfiguration dlSizeLimitConfiguration = this._getCompanyDLSizeLimitConfiguration(companyId);
        return dlSizeLimitConfiguration.maxSizeToCopy();
    }

    public Map<String, Long> getCompanyMimeTypeSizeLimit(long companyId) {
        return this._companyMimeTypeSizeLimitsMap.computeIfAbsent(companyId, this::_computeCompanyMimeTypeSizeLimit);
    }

    public long getCompanyMimeTypeSizeLimit(long companyId, String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return 0L;
        }
        Map map = this._companyMimeTypeSizeLimitsMap.computeIfAbsent(companyId, this::_computeCompanyMimeTypeSizeLimit);
        long sizeLimit = map.getOrDefault(mimeType, 0L);
        if (sizeLimit != 0L) {
            return sizeLimit;
        }
        List parts = StringUtil.split((String)mimeType, (char)'/');
        return map.getOrDefault(String.format("%s/*", parts.get(0)), 0L);
    }

    public long getGroupFileMaxSize(long groupId) {
        DLSizeLimitConfiguration dlSizeLimitConfiguration = this._getGroupDLSizeLimitConfiguration(groupId);
        return dlSizeLimitConfiguration.fileMaxSize();
    }

    public long getGroupMaxSizeToCopy(long groupId) {
        DLSizeLimitConfiguration dlSizeLimitConfiguration = this._getGroupDLSizeLimitConfiguration(groupId);
        return dlSizeLimitConfiguration.maxSizeToCopy();
    }

    public Map<String, Long> getGroupMimeTypeSizeLimit(long groupId) {
        return this._groupMimeTypeSizeLimitsMap.computeIfAbsent(groupId, this::_computeGroupMimeTypeSizeLimit);
    }

    public long getGroupMimeTypeSizeLimit(long groupId, String mimeType) {
        if (Validator.isNull((String)mimeType)) {
            return 0L;
        }
        Map map = this._groupMimeTypeSizeLimitsMap.computeIfAbsent(groupId, this::_computeGroupMimeTypeSizeLimit);
        long sizeLimit = map.getOrDefault(mimeType, 0L);
        if (sizeLimit != 0L) {
            return sizeLimit;
        }
        List parts = StringUtil.split((String)mimeType, (char)'/');
        return map.getOrDefault(String.format("%s/*", parts.get(0)), 0L);
    }

    public long getSystemFileMaxSize() {
        return this._systemDLSizeLimitConfiguration.fileMaxSize();
    }

    public long getSystemMaxSizeToCopy() {
        return this._systemDLSizeLimitConfiguration.maxSizeToCopy();
    }

    public Map<String, Long> getSystemMimeTypeSizeLimit() {
        return this._computeMimeTypeSizeLimit(this._systemDLSizeLimitConfiguration);
    }

    public void unmapPid(String pid) {
        if (this._companyIds.containsKey(pid)) {
            long companyId = this._companyIds.remove(pid);
            this._companyConfigurationBeans.remove(companyId);
            this._companyMimeTypeSizeLimitsMap.remove(companyId);
            this._groupMimeTypeSizeLimitsMap.clear();
        } else if (this._groupIds.containsKey(pid)) {
            long groupId = this._groupIds.remove(pid);
            this._groupConfigurationBeans.remove(groupId);
            this._groupMimeTypeSizeLimitsMap.remove(groupId);
        }
    }

    public void updateCompanyConfiguration(long companyId, String pid, Dictionary<String, ?> dictionary) {
        this._companyConfigurationBeans.put(companyId, (DLSizeLimitConfiguration)ConfigurableUtil.createConfigurable(DLSizeLimitConfiguration.class, dictionary));
        this._companyIds.put(pid, companyId);
        this._companyMimeTypeSizeLimitsMap.remove(companyId);
    }

    public void updateGroupConfiguration(long groupId, String pid, Dictionary<String, ?> dictionary) {
        this._groupConfigurationBeans.put(groupId, (DLSizeLimitConfiguration)ConfigurableUtil.createConfigurable(DLSizeLimitConfiguration.class, dictionary));
        this._groupIds.put(pid, groupId);
        this._groupMimeTypeSizeLimitsMap.remove(groupId);
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._companyMimeTypeSizeLimitsMap = new ConcurrentHashMap<Long, Map<String, Long>>();
        this._groupMimeTypeSizeLimitsMap = new ConcurrentHashMap<Long, Map<String, Long>>();
        this._systemDLSizeLimitConfiguration = (DLSizeLimitConfiguration)ConfigurableUtil.createConfigurable(DLSizeLimitConfiguration.class, properties);
    }

    private Map<String, Long> _computeCompanyMimeTypeSizeLimit(long companyId) {
        return this._computeMimeTypeSizeLimit(this._getCompanyDLSizeLimitConfiguration(companyId));
    }

    private Map<String, Long> _computeGroupMimeTypeSizeLimit(long groupId) {
        return this._computeMimeTypeSizeLimit(this._getGroupDLSizeLimitConfiguration(groupId));
    }

    private Map<String, Long> _computeMimeTypeSizeLimit(DLSizeLimitConfiguration dlSizeLimitConfiguration) {
        LinkedHashMap<String, Long> mimeTypeSizeLimits = new LinkedHashMap<String, Long>();
        for (String mimeTypeSizeLimit : dlSizeLimitConfiguration.mimeTypeSizeLimit()) {
            MimeTypeSizeLimitUtil.parseMimeTypeSizeLimit(mimeTypeSizeLimit, mimeTypeSizeLimits::put);
        }
        return mimeTypeSizeLimits;
    }

    private DLSizeLimitConfiguration _getCompanyDLSizeLimitConfiguration(long companyId) {
        return this._getDLSizeLimitConfiguration(companyId, this._companyConfigurationBeans, () -> this._systemDLSizeLimitConfiguration);
    }

    private DLSizeLimitConfiguration _getDLSizeLimitConfiguration(long key, Map<Long, DLSizeLimitConfiguration> configurationBeans, Supplier<DLSizeLimitConfiguration> supplier) {
        if (configurationBeans.containsKey(key)) {
            return configurationBeans.get(key);
        }
        return supplier.get();
    }

    private DLSizeLimitConfiguration _getGroupDLSizeLimitConfiguration(long groupId) {
        return this._getDLSizeLimitConfiguration(groupId, this._groupConfigurationBeans, () -> {
            Group group = this._groupLocalService.fetchGroup(groupId);
            long companyId = CompanyThreadLocal.getCompanyId();
            if (group != null) {
                companyId = group.getCompanyId();
            }
            return this._getCompanyDLSizeLimitConfiguration(companyId);
        });
    }
}

