/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.internal.util.DLExportableRepositoryPublisherUtil;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;
import java.util.Collection;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ModelListener.class})
public class DLFolderStagingModelListener
extends BaseModelListener<DLFolder> {
    @Reference
    private StagingModelListener<DLFolder> _stagingModelListener;

    public void onAfterCreate(DLFolder dlFolder) throws ModelListenerException {
        Collection<Long> exportableRepositoryIds = DLExportableRepositoryPublisherUtil.publish(dlFolder.getGroupId());
        if (!exportableRepositoryIds.contains(dlFolder.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterCreate((BaseModel)dlFolder);
    }

    public void onAfterRemove(DLFolder dlFolder) throws ModelListenerException {
        this._stagingModelListener.onAfterRemove((BaseModel)dlFolder);
    }

    public void onAfterUpdate(DLFolder originalDLFolder, DLFolder dlFolder) throws ModelListenerException {
        Collection<Long> exportableRepositoryIds = DLExportableRepositoryPublisherUtil.publish(dlFolder.getGroupId());
        if (!exportableRepositoryIds.contains(dlFolder.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterUpdate((BaseModel)dlFolder);
    }
}

