/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.change.tracking.spi.resolver;

import com.liferay.change.tracking.spi.resolver.ConstraintResolver;
import com.liferay.change.tracking.spi.resolver.context.ConstraintResolverContext;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TempFileEntryUtil;
import com.liferay.portal.language.LanguageResources;
import java.util.Locale;
import java.util.ResourceBundle;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConstraintResolver.class})
public class DLFolderNameConstraintResolver
implements ConstraintResolver<DLFolder> {
    private static final Log _log = LogFactoryUtil.getLog(DLFolderNameConstraintResolver.class);
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    private boolean _resolved;

    public String getConflictDescriptionKey() {
        return "duplicate-folder-name";
    }

    public Class<DLFolder> getModelClass() {
        return DLFolder.class;
    }

    public String getResolutionDescriptionKey() {
        if (this._resolved) {
            return "duplicate-folder-was-removed";
        }
        return "rename-the-folder-in-the-publication";
    }

    public ResourceBundle getResourceBundle(Locale locale) {
        return LanguageResources.getResourceBundle((Locale)locale);
    }

    public String[] getUniqueIndexColumnNames() {
        return new String[]{"groupId", "parentFolderId", "name"};
    }

    public void resolveConflict(ConstraintResolverContext<DLFolder> constraintResolverContext) {
        block3: {
            DLFolder sourceDLFolder = (DLFolder)constraintResolverContext.getSourceCTModel();
            DLFolder targetDLFolder = (DLFolder)constraintResolverContext.getTargetCTModel();
            if (StringUtil.equals((String)sourceDLFolder.getName(), (String)TempFileEntryUtil.class.getName()) && StringUtil.equals((String)targetDLFolder.getName(), (String)TempFileEntryUtil.class.getName())) {
                try {
                    this._dlFolderLocalService.deleteFolder(sourceDLFolder);
                    this._resolved = true;
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Object)("Unable to delete source document library folder " + sourceDLFolder.getFolderId()), (Throwable)portalException);
                }
            }
        }
    }
}

