/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.service.persistence.impl;

import com.liferay.document.library.exception.NoSuchStorageQuotaException;
import com.liferay.document.library.model.DLStorageQuota;
import com.liferay.document.library.model.DLStorageQuotaTable;
import com.liferay.document.library.model.impl.DLStorageQuotaImpl;
import com.liferay.document.library.model.impl.DLStorageQuotaModelImpl;
import com.liferay.document.library.service.persistence.DLStorageQuotaPersistence;
import com.liferay.document.library.service.persistence.DLStorageQuotaUtil;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLStorageQuotaPersistence.class})
public class DLStorageQuotaPersistenceImpl
extends BasePersistenceImpl<DLStorageQuota>
implements DLStorageQuotaPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DLStorageQuotaImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathFetchByCompanyId;
    private static final String _FINDER_COLUMN_COMPANYID_COMPANYID_2 = "dlStorageQuota.companyId = ?";
    private int _valueObjectFinderCacheListThreshold;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DLSTORAGEQUOTA = "SELECT dlStorageQuota FROM DLStorageQuota dlStorageQuota";
    private static final String _SQL_SELECT_DLSTORAGEQUOTA_WHERE = "SELECT dlStorageQuota FROM DLStorageQuota dlStorageQuota WHERE ";
    private static final String _SQL_COUNT_DLSTORAGEQUOTA = "SELECT COUNT(dlStorageQuota) FROM DLStorageQuota dlStorageQuota";
    private static final String _SQL_COUNT_DLSTORAGEQUOTA_WHERE = "SELECT COUNT(dlStorageQuota) FROM DLStorageQuota dlStorageQuota WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "dlStorageQuota.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DLStorageQuota exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DLStorageQuota exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DLStorageQuotaPersistenceImpl.class);

    public DLStorageQuota findByCompanyId(long companyId) throws NoSuchStorageQuotaException {
        DLStorageQuota dlStorageQuota = this.fetchByCompanyId(companyId);
        if (dlStorageQuota == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchStorageQuotaException(sb.toString());
        }
        return dlStorageQuota;
    }

    public DLStorageQuota fetchByCompanyId(long companyId) {
        return this.fetchByCompanyId(companyId, true);
    }

    public DLStorageQuota fetchByCompanyId(long companyId, boolean useFinderCache) {
        DLStorageQuota dlStorageQuota;
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByCompanyId, finderArgs, (BasePersistence)this);
        }
        if (result instanceof DLStorageQuota && companyId != (dlStorageQuota = (DLStorageQuota)result).getCompanyId()) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_SELECT_DLSTORAGEQUOTA_WHERE);
            sb.append(_FINDER_COLUMN_COMPANYID_COMPANYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                List list = query.list();
                if (list.isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByCompanyId, finderArgs, (Object)list);
                    }
                } else {
                    DLStorageQuota dlStorageQuota2 = (DLStorageQuota)list.get(0);
                    result = dlStorageQuota2;
                    this.cacheResult(dlStorageQuota2);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLStorageQuota)result;
    }

    public DLStorageQuota removeByCompanyId(long companyId) throws NoSuchStorageQuotaException {
        DLStorageQuota dlStorageQuota = this.findByCompanyId(companyId);
        return (DLStorageQuota)this.remove((BaseModel)dlStorageQuota);
    }

    public int countByCompanyId(long companyId) {
        DLStorageQuota dlStorageQuota = this.fetchByCompanyId(companyId);
        if (dlStorageQuota == null) {
            return 0;
        }
        return 1;
    }

    public DLStorageQuotaPersistenceImpl() {
        this.setModelClass(DLStorageQuota.class);
        this.setModelImplClass(DLStorageQuotaImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DLStorageQuotaTable.INSTANCE);
    }

    public void cacheResult(DLStorageQuota dlStorageQuota) {
        this.entityCache.putResult(DLStorageQuotaImpl.class, (Serializable)Long.valueOf(dlStorageQuota.getPrimaryKey()), (Serializable)dlStorageQuota);
        this.finderCache.putResult(this._finderPathFetchByCompanyId, new Object[]{dlStorageQuota.getCompanyId()}, (Object)dlStorageQuota);
    }

    public void cacheResult(List<DLStorageQuota> dlStorageQuotas) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && dlStorageQuotas.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (DLStorageQuota dlStorageQuota : dlStorageQuotas) {
            if (this.entityCache.getResult(DLStorageQuotaImpl.class, (Serializable)Long.valueOf(dlStorageQuota.getPrimaryKey())) != null) continue;
            this.cacheResult(dlStorageQuota);
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DLStorageQuotaImpl.class);
        this.finderCache.clearCache(DLStorageQuotaImpl.class);
    }

    public void clearCache(DLStorageQuota dlStorageQuota) {
        this.entityCache.removeResult(DLStorageQuotaImpl.class, (BaseModel)dlStorageQuota);
    }

    public void clearCache(List<DLStorageQuota> dlStorageQuotas) {
        for (DLStorageQuota dlStorageQuota : dlStorageQuotas) {
            this.entityCache.removeResult(DLStorageQuotaImpl.class, (BaseModel)dlStorageQuota);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(DLStorageQuotaImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DLStorageQuotaImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DLStorageQuotaModelImpl dlStorageQuotaModelImpl) {
        Object[] args = new Object[]{dlStorageQuotaModelImpl.getCompanyId()};
        this.finderCache.putResult(this._finderPathFetchByCompanyId, args, (Object)dlStorageQuotaModelImpl);
    }

    public DLStorageQuota create(long dlStorageQuotaId) {
        DLStorageQuotaImpl dlStorageQuota = new DLStorageQuotaImpl();
        dlStorageQuota.setNew(true);
        dlStorageQuota.setPrimaryKey(dlStorageQuotaId);
        dlStorageQuota.setCompanyId(CompanyThreadLocal.getCompanyId());
        return dlStorageQuota;
    }

    public DLStorageQuota remove(long dlStorageQuotaId) throws NoSuchStorageQuotaException {
        return this.remove(Long.valueOf(dlStorageQuotaId));
    }

    public DLStorageQuota remove(Serializable primaryKey) throws NoSuchStorageQuotaException {
        Session session = null;
        try {
            session = this.openSession();
            DLStorageQuota dlStorageQuota = (DLStorageQuota)session.get(DLStorageQuotaImpl.class, primaryKey);
            if (dlStorageQuota == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchStorageQuotaException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DLStorageQuota dLStorageQuota = (DLStorageQuota)this.remove((BaseModel)dlStorageQuota);
            return dLStorageQuota;
        }
        catch (NoSuchStorageQuotaException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLStorageQuota removeImpl(DLStorageQuota dlStorageQuota) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)dlStorageQuota)) {
                dlStorageQuota = (DLStorageQuota)session.get(DLStorageQuotaImpl.class, dlStorageQuota.getPrimaryKeyObj());
            }
            if (dlStorageQuota != null) {
                session.delete((Object)dlStorageQuota);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (dlStorageQuota != null) {
            this.clearCache(dlStorageQuota);
        }
        return dlStorageQuota;
    }

    public DLStorageQuota updateImpl(DLStorageQuota dlStorageQuota) {
        boolean isNew = dlStorageQuota.isNew();
        if (!(dlStorageQuota instanceof DLStorageQuotaModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(dlStorageQuota.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)dlStorageQuota);
                throw new IllegalArgumentException("Implement ModelWrapper in dlStorageQuota proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DLStorageQuota implementation " + dlStorageQuota.getClass());
        }
        DLStorageQuotaModelImpl dlStorageQuotaModelImpl = (DLStorageQuotaModelImpl)dlStorageQuota;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)dlStorageQuota);
            } else {
                dlStorageQuota = (DLStorageQuota)session.merge((Object)dlStorageQuota);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(DLStorageQuotaImpl.class, (BaseModel)dlStorageQuotaModelImpl, false, true);
        this.cacheUniqueFindersCache(dlStorageQuotaModelImpl);
        if (isNew) {
            dlStorageQuota.setNew(false);
        }
        dlStorageQuota.resetOriginalValues();
        return dlStorageQuota;
    }

    public DLStorageQuota findByPrimaryKey(Serializable primaryKey) throws NoSuchStorageQuotaException {
        DLStorageQuota dlStorageQuota = (DLStorageQuota)this.fetchByPrimaryKey(primaryKey);
        if (dlStorageQuota == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchStorageQuotaException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return dlStorageQuota;
    }

    public DLStorageQuota findByPrimaryKey(long dlStorageQuotaId) throws NoSuchStorageQuotaException {
        return this.findByPrimaryKey(Long.valueOf(dlStorageQuotaId));
    }

    public DLStorageQuota fetchByPrimaryKey(long dlStorageQuotaId) {
        return (DLStorageQuota)this.fetchByPrimaryKey(Long.valueOf(dlStorageQuotaId));
    }

    public List<DLStorageQuota> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DLStorageQuota> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DLStorageQuota> findAll(int start, int end, OrderByComparator<DLStorageQuota> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DLStorageQuota> findAll(int start, int end, OrderByComparator<DLStorageQuota> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DLSTORAGEQUOTA);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DLSTORAGEQUOTA;
                sql = sql.concat(" ORDER BY dlStorageQuota.dlStorageQuotaId ASC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DLStorageQuota dlStorageQuota : this.findAll()) {
            this.remove((BaseModel)dlStorageQuota);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DLSTORAGEQUOTA);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "dlStorageQuotaId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DLSTORAGEQUOTA;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DLStorageQuotaModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathFetchByCompanyId = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByCompanyId", new String[]{Long.class.getName()}, new String[]{"companyId"}, true);
        DLStorageQuotaUtil.setPersistence((DLStorageQuotaPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        DLStorageQuotaUtil.setPersistence(null);
        this.entityCache.removeCache(DLStorageQuotaImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.document.library.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }
}

