/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.portal.kernel.dao.orm.QueryDefinition;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.event.RepositoryEventAware;
import com.liferay.portal.kernel.repository.event.RepositoryEventListener;
import com.liferay.portal.kernel.repository.event.RepositoryEventType;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.registry.RepositoryEventRegistry;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.capabilities.util.DLAppServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFileEntryServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFolderServiceAdapter;
import com.liferay.portal.repository.capabilities.util.RepositoryServiceAdapter;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.trash.TrashHelper;
import com.liferay.trash.model.TrashEntry;
import com.liferay.trash.service.TrashEntryLocalService;
import com.liferay.trash.service.TrashVersionLocalService;
import java.util.List;

public class LiferayTrashCapability
implements RepositoryEventAware,
TrashCapability {
    private final DLAppHelperLocalService _dlAppHelperLocalService;
    private final DLAppServiceAdapter _dlAppServiceAdapter;
    private final DLFileEntryServiceAdapter _dlFileEntryServiceAdapter;
    private final DLFolderServiceAdapter _dlFolderServiceAdapter;
    private final RepositoryServiceAdapter _repositoryServiceAdapter;
    private final TrashEntryLocalService _trashEntryLocalService;
    private final TrashHelper _trashHelper;
    private final TrashVersionLocalService _trashVersionLocalService;

    public LiferayTrashCapability(DLAppHelperLocalService dlAppHelperLocalService, DLAppServiceAdapter dlAppServiceAdapter, DLFileEntryServiceAdapter dlFileEntryServiceAdapter, DLFolderServiceAdapter dlFolderServiceAdapter, RepositoryServiceAdapter repositoryServiceAdapter, TrashEntryLocalService trashEntryLocalService, TrashHelper trashHelper, TrashVersionLocalService trashVersionLocalService) {
        this._dlAppHelperLocalService = dlAppHelperLocalService;
        this._dlAppServiceAdapter = dlAppServiceAdapter;
        this._dlFileEntryServiceAdapter = dlFileEntryServiceAdapter;
        this._dlFolderServiceAdapter = dlFolderServiceAdapter;
        this._repositoryServiceAdapter = repositoryServiceAdapter;
        this._trashEntryLocalService = trashEntryLocalService;
        this._trashHelper = trashHelper;
        this._trashVersionLocalService = trashVersionLocalService;
    }

    public void deleteFileEntry(FileEntry fileEntry) throws PortalException {
        this._deleteTrashEntry(fileEntry);
        this._dlAppServiceAdapter.deleteFileEntry(fileEntry.getFileEntryId());
    }

    public void deleteFolder(Folder folder) throws PortalException {
        List dlFileEntries = this._dlFileEntryServiceAdapter.getGroupFileEntries(folder.getGroupId(), 0, folder.getRepositoryId(), folder.getFolderId(), -1, -1, null);
        for (DLFileEntry dlFileEntry : dlFileEntries) {
            LiferayFileEntry fileEntry = new LiferayFileEntry(dlFileEntry);
            this._dlAppHelperLocalService.deleteFileEntry((FileEntry)fileEntry);
            this._deleteTrashEntry((FileEntry)fileEntry);
        }
        this._dlAppHelperLocalService.deleteFolder(folder);
        this._deleteTrashEntry(folder);
        this._dlFolderServiceAdapter.deleteFolder(folder.getFolderId(), false);
    }

    public boolean isInTrash(FileEntry fileEntry) throws PortalException {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        return dlFileEntry.isInTrash();
    }

    public boolean isInTrash(Folder folder) {
        DLFolder dlFolder = (DLFolder)folder.getModel();
        return dlFolder.isInTrash();
    }

    public FileEntry moveFileEntryFromTrash(long userId, FileEntry fileEntry, Folder newFolder, ServiceContext serviceContext) throws PortalException {
        long newFolderId = 0L;
        if (newFolder != null) {
            newFolderId = newFolder.getFolderId();
        }
        return this._dlAppHelperLocalService.moveFileEntryFromTrash(userId, fileEntry, newFolderId, serviceContext);
    }

    public FileEntry moveFileEntryToTrash(long userId, FileEntry fileEntry) throws PortalException {
        return this._dlAppHelperLocalService.moveFileEntryToTrash(userId, fileEntry);
    }

    public FileShortcut moveFileShortcutFromTrash(long userId, FileShortcut fileShortcut, Folder newFolder, ServiceContext serviceContext) throws PortalException {
        long newFolderId = 0L;
        if (newFolder != null) {
            newFolderId = newFolder.getFolderId();
        }
        return this._dlAppHelperLocalService.moveFileShortcutFromTrash(userId, fileShortcut, newFolderId, serviceContext);
    }

    public FileShortcut moveFileShortcutToTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        return this._dlAppHelperLocalService.moveFileShortcutToTrash(userId, fileShortcut);
    }

    public Folder moveFolderFromTrash(long userId, Folder folder, Folder destinationFolder, ServiceContext serviceContext) throws PortalException {
        long destinationFolderId = 0L;
        if (destinationFolder != null) {
            destinationFolderId = destinationFolder.getFolderId();
        }
        return this._dlAppHelperLocalService.moveFolderFromTrash(userId, folder, destinationFolderId, serviceContext);
    }

    public Folder moveFolderToTrash(long userId, Folder folder) throws PortalException {
        return this._dlAppHelperLocalService.moveFolderToTrash(userId, folder);
    }

    public void registerRepositoryEventListeners(RepositoryEventRegistry repositoryEventRegistry) {
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, FileEntry.class, (RepositoryEventListener)new DeleteFileEntryRepositoryEventListener());
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, Folder.class, (RepositoryEventListener)new DeleteFolderRepositoryEventListener());
        repositoryEventRegistry.registerRepositoryEventListener(RepositoryEventType.Delete.class, LocalRepository.class, (RepositoryEventListener)new DeleteLocalRepositoryEventListener());
    }

    public void restoreFileEntryFromTrash(long userId, FileEntry fileEntry) throws PortalException {
        this._dlAppHelperLocalService.restoreFileEntryFromTrash(userId, fileEntry);
    }

    public void restoreFileShortcutFromTrash(long userId, FileShortcut fileShortcut) throws PortalException {
        this._dlAppHelperLocalService.restoreFileShortcutFromTrash(userId, fileShortcut);
    }

    public void restoreFolderFromTrash(long userId, Folder folder) throws PortalException {
        this._dlAppHelperLocalService.restoreFolderFromTrash(userId, folder);
    }

    private void _deleteRepositoryTrashEntries(long repositoryId, String className) {
        List trashEntries = this._trashEntryLocalService.getEntries(repositoryId, className);
        for (TrashEntry trashEntry : trashEntries) {
            this._trashEntryLocalService.deleteTrashEntry(trashEntry);
        }
    }

    private void _deleteTrashEntries(long repositoryId) throws PortalException {
        Repository repository = this._repositoryServiceAdapter.fetchRepository(repositoryId);
        if (repository == null) {
            this._deleteRepositoryTrashEntries(repositoryId, DLFileEntry.class.getName());
            this._deleteRepositoryTrashEntries(repositoryId, DLFolder.class.getName());
        } else {
            this._deleteTrashEntries(repository.getGroupId(), repository.getDlFolderId());
        }
    }

    private void _deleteTrashEntries(long groupId, long dlFolderId) throws PortalException {
        QueryDefinition queryDefinition = new QueryDefinition();
        queryDefinition.setStatus(-1);
        List foldersAndFileEntriesAndFileShortcuts = this._dlFolderServiceAdapter.getFoldersAndFileEntriesAndFileShortcuts(groupId, dlFolderId, null, true, queryDefinition);
        for (Object folderFileEntryOrFileShortcut : foldersAndFileEntriesAndFileShortcuts) {
            if (folderFileEntryOrFileShortcut instanceof DLFileEntry) {
                this._deleteTrashEntry((DLFileEntry)folderFileEntryOrFileShortcut);
                continue;
            }
            if (!(folderFileEntryOrFileShortcut instanceof DLFolder)) continue;
            DLFolder dlFolder = (DLFolder)folderFileEntryOrFileShortcut;
            this._deleteTrashEntries(dlFolder.getGroupId(), dlFolder.getFolderId());
            this._deleteTrashEntry(dlFolder);
        }
    }

    private void _deleteTrashEntry(DLFileEntry dlFileEntry) {
        if (!dlFileEntry.isInTrash()) {
            return;
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)dlFileEntry)) {
            this._trashEntryLocalService.deleteEntry(DLFileEntryConstants.getClassName(), dlFileEntry.getFileEntryId());
        } else {
            List dlFileVersions = dlFileEntry.getFileVersions(-1);
            for (DLFileVersion dlFileVersion : dlFileVersions) {
                this._trashVersionLocalService.deleteTrashVersion(DLFileVersion.class.getName(), dlFileVersion.getFileVersionId());
            }
        }
    }

    private void _deleteTrashEntry(DLFolder dlFolder) {
        if (!dlFolder.isInTrash()) {
            return;
        }
        if (this._trashHelper.isInTrashExplicitly((TrashedModel)dlFolder)) {
            this._trashEntryLocalService.deleteEntry(DLFolderConstants.getClassName(), dlFolder.getFolderId());
        } else {
            this._trashVersionLocalService.deleteTrashVersion(DLFolderConstants.getClassName(), dlFolder.getFolderId());
        }
    }

    private void _deleteTrashEntry(FileEntry fileEntry) {
        this._deleteTrashEntry((DLFileEntry)fileEntry.getModel());
    }

    private void _deleteTrashEntry(Folder folder) {
        this._deleteTrashEntry((DLFolder)folder.getModel());
    }

    private class DeleteFileEntryRepositoryEventListener
    implements RepositoryEventListener<RepositoryEventType.Delete, FileEntry> {
        private DeleteFileEntryRepositoryEventListener() {
        }

        public void execute(FileEntry fileEntry) {
            LiferayTrashCapability.this._deleteTrashEntry(fileEntry);
        }
    }

    private class DeleteFolderRepositoryEventListener
    implements RepositoryEventListener<RepositoryEventType.Delete, Folder> {
        private DeleteFolderRepositoryEventListener() {
        }

        public void execute(Folder folder) {
            LiferayTrashCapability.this._deleteTrashEntry(folder);
        }
    }

    private class DeleteLocalRepositoryEventListener
    implements RepositoryEventListener<RepositoryEventType.Delete, LocalRepository> {
        private DeleteLocalRepositoryEventListener() {
        }

        public void execute(LocalRepository localRepository) throws PortalException {
            LiferayTrashCapability.this._deleteTrashEntries(localRepository.getRepositoryId());
        }
    }
}

