/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.store.Store;
import com.liferay.document.library.kernel.util.comparator.FileVersionVersionComparator;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.convert.BaseConvertProcess;
import com.liferay.portal.convert.ConvertProcess;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.util.MaintenanceUtil;
import com.liferay.portal.util.PropsValues;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={ConvertProcess.class})
public class DocumentLibraryConvertProcess
extends BaseConvertProcess {
    private ServiceTrackerList<DLStoreConvertProcess> _dlStoreConvertProcesses;
    private ServiceTrackerMap<String, Store> _serviceTrackerMap;
    @Reference(target="(default=true)")
    private Store _store;

    public String getConfigurationErrorMessage() {
        return "there-are-no-stores-configured";
    }

    public String getDescription() {
        return "migrate-documents-from-one-repository-to-another";
    }

    public String getParameterDescription() {
        return "please-select-a-new-repository-hook";
    }

    public String[] getParameterNames() {
        Set storeTypes = this._serviceTrackerMap.keySet();
        StringBundler sb = new StringBundler(storeTypes.size() * 2 + 2);
        sb.append("dl.store.impl");
        sb.append("=");
        for (String storeType : storeTypes) {
            Class<?> clazz;
            if (storeType.equals((clazz = this._store.getClass()).getName())) continue;
            sb.append(storeType);
            sb.append(";");
        }
        return new String[]{sb.toString(), "delete-files-from-previous-repository=checkbox"};
    }

    public boolean isEnabled() {
        return true;
    }

    public void validate() {
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._serviceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, Store.class, (String)"(ct.aware=true)", (serviceReference1, emitter) -> emitter.emit((Object)String.valueOf(serviceReference1.getProperty("store.type"))));
        this._dlStoreConvertProcesses = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLStoreConvertProcess.class);
    }

    @Deactivate
    protected void deactivate() {
        this._dlStoreConvertProcesses.close();
        this._serviceTrackerMap.close();
    }

    protected void doConvert() throws Exception {
        String targetStoreClassName = this.getTargetStoreClassName();
        this.migrateDLStoreConvertProcesses(this._store, (Store)this._serviceTrackerMap.getService((Object)targetStoreClassName));
        MaintenanceUtil.appendStatus((String)StringBundler.concat((String[])new String[]{"Please set ", "dl.store.impl", " in your portal-ext.properties to use ", targetStoreClassName}));
        PropsValues.DL_STORE_IMPL = targetStoreClassName;
    }

    protected List<FileVersion> getFileVersions(FileEntry fileEntry) {
        return ListUtil.sort((List)fileEntry.getFileVersions(-1), (Comparator)new FileVersionVersionComparator(true));
    }

    protected String getTargetStoreClassName() {
        String[] values = this.getParameterValues();
        return values[0];
    }

    protected boolean isDeleteFilesFromSourceStore() {
        String[] values = this.getParameterValues();
        return GetterUtil.getBoolean((String)values[1]);
    }

    protected void migrateDLStoreConvertProcesses(Store sourceStore, Store targetStore) throws PortalException {
        Collection<DLStoreConvertProcess> dlStoreConvertProcesses = this._getDLStoreConvertProcesses();
        for (DLStoreConvertProcess dlStoreConvertProcess : dlStoreConvertProcesses) {
            if (this.isDeleteFilesFromSourceStore()) {
                dlStoreConvertProcess.move(sourceStore, targetStore);
                continue;
            }
            dlStoreConvertProcess.copy(sourceStore, targetStore);
        }
    }

    private Collection<DLStoreConvertProcess> _getDLStoreConvertProcesses() {
        return this._dlStoreConvertProcesses.toList();
    }
}

