/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.util.ImageProcessorUtil;
import com.liferay.document.library.kernel.util.PDFProcessorUtil;
import com.liferay.document.library.kernel.util.VideoProcessorUtil;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.PortletProvider;
import com.liferay.portal.kernel.portlet.PortletProviderUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.Http;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.URLCodec;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.webdav.DLWebDAVUtil;
import com.liferay.trash.TrashHelper;
import java.util.Date;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLURLHelper.class})
public class DLURLHelperImpl
implements DLURLHelper {
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    @Reference
    private Http _http;
    @Reference
    private Portal _portal;
    @Reference
    private TrashHelper _trashHelper;

    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getDownloadURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getDownloadURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String previewURL = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        return this._http.addParameter(previewURL, "download", true);
    }

    public String getFileEntryControlPanelLink(PortletRequest portletRequest, long fileEntryId) {
        String portletId = PortletProviderUtil.getPortletId((String)FileEntry.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntryId));
        return portletURL.toString();
    }

    public String getFolderControlPanelLink(PortletRequest portletRequest, long folderId) {
        String portletId = PortletProviderUtil.getPortletId((String)Folder.class.getName(), (PortletProvider.Action)PortletProvider.Action.MANAGE);
        PortletURL portletURL = this._portal.getControlPanelPortletURL(portletRequest, portletId, "RENDER_PHASE");
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        return portletURL.toString();
    }

    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) {
        return this.getImagePreviewURL(fileEntry, fileVersion, themeDisplay, null, true, true);
    }

    public String getImagePreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        if (this._dlFileVersionPreviewLocalService.hasDLFileVersionPreview(fileEntry.getFileEntryId(), fileVersion.getFileVersionId(), 1)) {
            return "";
        }
        String previewQueryString = queryString;
        if (Validator.isNull((String)previewQueryString)) {
            previewQueryString = "";
        }
        if (ImageProcessorUtil.isSupported((String)fileVersion.getMimeType()) || ArrayUtil.contains((Object[])PropsValues.DL_FILE_ENTRY_PREVIEW_IMAGE_MIME_TYPES, (Object)fileEntry.getMimeType())) {
            previewQueryString = previewQueryString.concat("&imagePreview=1");
        } else if (PropsValues.DL_FILE_ENTRY_PREVIEW_ENABLED) {
            if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                previewQueryString = previewQueryString.concat("&previewFileIndex=1");
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                previewQueryString = previewQueryString.concat("&videoThumbnail=1");
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, previewQueryString, appendVersion, absoluteURL);
    }

    public String getImagePreviewURL(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getImagePreviewURL(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    public String getPreviewURL(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        StringBundler sb = new StringBundler(15);
        if (themeDisplay != null && absoluteURL) {
            sb.append(themeDisplay.getPortalURL());
        }
        sb.append(this._portal.getPathContext());
        sb.append("/documents/");
        sb.append(fileEntry.getRepositoryId());
        sb.append("/");
        sb.append(fileEntry.getFolderId());
        sb.append("/");
        String fileName = fileEntry.getFileName();
        if (fileEntry.isInTrash()) {
            fileName = this._trashHelper.getOriginalTitle(fileEntry.getFileName());
        }
        sb.append(URLCodec.encodeURL((String)HtmlUtil.unescape((String)fileName)));
        sb.append("/");
        sb.append(URLCodec.encodeURL((String)fileEntry.getUuid()));
        if (appendVersion) {
            sb.append("?version=");
            sb.append(fileVersion.getVersion());
            sb.append("&t=");
        } else {
            sb.append("?t=");
        }
        Date modifiedDate = fileVersion.getModifiedDate();
        sb.append(modifiedDate.getTime());
        sb.append(queryString);
        String previewURL = sb.toString();
        if (themeDisplay != null && themeDisplay.isAddSessionIdToURL()) {
            return this._portal.getURLWithSessionId(previewURL, themeDisplay.getSessionId());
        }
        return previewURL;
    }

    public String getThumbnailSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay) {
        if (this._dlFileVersionPreviewLocalService.hasDLFileVersionPreview(fileEntry.getFileEntryId(), fileVersion.getFileVersionId(), 1)) {
            return "";
        }
        String thumbnailQueryString = null;
        if (PropsValues.DL_FILE_ENTRY_THUMBNAIL_ENABLED) {
            if (ImageProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&imageThumbnail=1";
            } else if (PDFProcessorUtil.hasImages((FileVersion)fileVersion)) {
                thumbnailQueryString = "&documentThumbnail=1";
            } else if (VideoProcessorUtil.hasVideo((FileVersion)fileVersion)) {
                thumbnailQueryString = "&videoThumbnail=1";
            }
        }
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, thumbnailQueryString);
    }

    public String getThumbnailSrc(FileEntry fileEntry, ThemeDisplay themeDisplay) throws Exception {
        return this.getThumbnailSrc(fileEntry, fileEntry.getFileVersion(), themeDisplay);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired) throws PortalException {
        return this.getWebDavURL(themeDisplay, folder, fileEntry, manualCheckInRequired, false);
    }

    public String getWebDavURL(ThemeDisplay themeDisplay, Folder folder, FileEntry fileEntry, boolean manualCheckInRequired, boolean openDocumentUrl) throws PortalException {
        StringBundler webDavURLSB = new StringBundler(7);
        boolean secure = false;
        if (themeDisplay.isSecure() || PropsValues.WEBDAV_SERVLET_HTTPS_REQUIRED) {
            secure = true;
        }
        String portalURL = this._portal.getPortalURL(themeDisplay.getServerName(), themeDisplay.getServerPort(), secure);
        webDavURLSB.append(portalURL);
        webDavURLSB.append(themeDisplay.getPathContext());
        webDavURLSB.append("/webdav");
        if (manualCheckInRequired) {
            webDavURLSB.append("/manualCheckInRequired");
        }
        Group group = null;
        group = fileEntry != null ? this._groupLocalService.getGroup(fileEntry.getGroupId()) : themeDisplay.getScopeGroup();
        webDavURLSB.append(group.getFriendlyURL());
        webDavURLSB.append("/document_library");
        StringBuilder sb = new StringBuilder();
        if (folder != null && folder.getFolderId() != 0L) {
            Folder curFolder = folder;
            while (true) {
                sb.insert(0, URLCodec.encodeURL((String)curFolder.getName(), (boolean)true));
                sb.insert(0, "/");
                if (curFolder.getParentFolderId() == 0L) break;
                curFolder = this._dlAppLocalService.getFolder(curFolder.getParentFolderId());
            }
        }
        if (fileEntry != null) {
            sb.append("/");
            sb.append(DLWebDAVUtil.escapeURLTitle((String)fileEntry.getFileName()));
        }
        webDavURLSB.append(sb.toString());
        return webDavURLSB.toString();
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString) {
        return this.getImageSrc(fileEntry, fileVersion, themeDisplay, queryString, true, true);
    }

    protected String getImageSrc(FileEntry fileEntry, FileVersion fileVersion, ThemeDisplay themeDisplay, String queryString, boolean appendVersion, boolean absoluteURL) {
        String thumbnailSrc = "";
        if (Validator.isNotNull((String)queryString)) {
            thumbnailSrc = this.getPreviewURL(fileEntry, fileVersion, themeDisplay, queryString, appendVersion, absoluteURL);
        }
        return thumbnailSrc;
    }
}

