/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.repository.capabilities.WorkflowSupport;
import com.liferay.portal.repository.capabilities.util.DLFileEntryServiceAdapter;
import com.liferay.portal.repository.liferayrepository.LiferayWorkflowLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.LiferayWorkflowRepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapperAware;
import java.util.Collections;
import java.util.Map;

public class MinimalWorkflowCapability
implements RepositoryWrapperAware,
WorkflowCapability,
WorkflowSupport {
    private final DLFileEntryServiceAdapter _dlFileEntryServiceAdapter;

    public MinimalWorkflowCapability(DLFileEntryServiceAdapter dlFileEntryServiceAdapter) {
        this._dlFileEntryServiceAdapter = dlFileEntryServiceAdapter;
    }

    public void addFileEntry(long userId, FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        this.doUpdateStatus(userId, fileEntry, serviceContext);
    }

    public void checkInFileEntry(long userId, FileEntry fileEntry, DLVersionNumberIncrease dlVersionNumberIncrease, ServiceContext serviceContext) throws PortalException {
        this.doUpdateStatus(userId, fileEntry, serviceContext);
    }

    public int getStatus(FileEntry fileEntry) {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        return dlFileEntry.getStatus();
    }

    public void revertFileEntry(long userId, FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        this.doUpdateStatus(userId, fileEntry, serviceContext);
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, DLVersionNumberIncrease dlVersionNumberIncrease, ServiceContext serviceContext) throws PortalException {
        this.doUpdateStatus(userId, fileEntry, serviceContext);
    }

    public LocalRepository wrapLocalRepository(LocalRepository localRepository) {
        return new LiferayWorkflowLocalRepositoryWrapper(localRepository, (WorkflowSupport)this);
    }

    public Repository wrapRepository(Repository repository) {
        return new LiferayWorkflowRepositoryWrapper(repository, (WorkflowSupport)this);
    }

    protected void doUpdateStatus(long userId, FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        Map workflowContext = Collections.emptyMap();
        FileVersion fileVersion = fileEntry.getFileVersion();
        this._dlFileEntryServiceAdapter.updateStatus(userId, fileVersion.getFileVersionId(), 0, serviceContext, workflowContext);
    }
}

