/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.exportimport.data.handler;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.exportimport.data.handler.base.BaseStagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.ExportImportPathUtil;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.lar.StagedModelModifiedDateComparator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.service.GroupLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HashMapBuilder;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={StagedModelDataHandler.class})
public class DLFileEntryTypeStagedModelDataHandler
extends BaseStagedModelDataHandler<DLFileEntryType> {
    public static final String[] CLASS_NAMES = new String[]{DLFileEntryType.class.getName()};
    private DDMStructureLocalService _ddmStructureLocalService;
    private DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    @Reference
    private GroupLocalService _groupLocalService;
    private UserLocalService _userLocalService;

    public void deleteStagedModel(DLFileEntryType fileEntryType) throws PortalException {
        this._dlFileEntryTypeLocalService.deleteFileEntryType(fileEntryType);
    }

    public void deleteStagedModel(String uuid, long groupId, String className, String extraData) throws PortalException {
        DLFileEntryType dlFileEntryType = this.fetchStagedModelByUuidAndGroupId(uuid, groupId);
        if (dlFileEntryType != null) {
            this.deleteStagedModel(dlFileEntryType);
        }
    }

    public DLFileEntryType fetchStagedModelByUuidAndGroupId(String uuid, long groupId) {
        return this._dlFileEntryTypeLocalService.fetchDLFileEntryTypeByUuidAndGroupId(uuid, groupId);
    }

    public List<DLFileEntryType> fetchStagedModelsByUuidAndCompanyId(String uuid, long companyId) {
        return this._dlFileEntryTypeLocalService.getDLFileEntryTypesByUuidAndCompanyId(uuid, companyId, -1, -1, (OrderByComparator)new StagedModelModifiedDateComparator());
    }

    public String[] getClassNames() {
        return CLASS_NAMES;
    }

    public Map<String, String> getReferenceAttributes(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) {
        return HashMapBuilder.put((Object)"file-entry-type-key", (Object)fileEntryType.getFileEntryTypeKey()).put((Object)"preloaded", () -> {
            long defaultUserId = 0L;
            try {
                defaultUserId = this._userLocalService.getDefaultUserId(fileEntryType.getCompanyId());
            }
            catch (Exception exception) {
                // empty catch block
            }
            boolean preloaded = false;
            if (fileEntryType.getFileEntryTypeId() == 0L || defaultUserId == fileEntryType.getUserId()) {
                preloaded = true;
            }
            return String.valueOf(preloaded);
        }).build();
    }

    public boolean validateReference(PortletDataContext portletDataContext, Element referenceElement) {
        this.validateMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        if (!preloaded) {
            return super.validateMissingReference(uuid, groupId);
        }
        String fileEntryTypeKey = referenceElement.attributeValue("file-entry-type-key");
        DLFileEntryType existingFileEntryType = this.fetchExistingFileEntryTypeWithParentGroups(uuid, groupId, fileEntryTypeKey, preloaded);
        return existingFileEntryType != null;
    }

    protected void doExportStagedModel(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) throws Exception {
        Element fileEntryTypeElement = portletDataContext.getExportDataElement((ClassedModel)fileEntryType);
        List ddmStructures = fileEntryType.getDDMStructures();
        for (DDMStructure ddmStructure : ddmStructures) {
            com.liferay.dynamic.data.mapping.model.DDMStructure structure = this._ddmStructureLocalService.getStructure(ddmStructure.getStructureId());
            Element referenceElement = StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (StagedModel)fileEntryType, (StagedModel)structure, (String)"strong");
            referenceElement.addAttribute("structure-id", String.valueOf(ddmStructure.getStructureId()));
        }
        long defaultUserId = this._userLocalService.getDefaultUserId(fileEntryType.getCompanyId());
        if (defaultUserId == fileEntryType.getUserId()) {
            fileEntryTypeElement.addAttribute("preloaded", "true");
        }
        portletDataContext.addClassedModel(fileEntryTypeElement, ExportImportPathUtil.getModelPath((StagedModel)fileEntryType), (ClassedModel)fileEntryType);
    }

    protected void doImportMissingReference(PortletDataContext portletDataContext, Element referenceElement) throws PortletDataException {
        this.importMissingGroupReference(portletDataContext, referenceElement);
        String uuid = referenceElement.attributeValue("uuid");
        Map groupIds = portletDataContext.getNewPrimaryKeysMap(Group.class);
        long groupId = GetterUtil.getLong((String)referenceElement.attributeValue("group-id"));
        groupId = MapUtil.getLong((Map)groupIds, (long)groupId);
        String fileEntryTypeKey = referenceElement.attributeValue("file-entry-type-key");
        boolean preloaded = GetterUtil.getBoolean((String)referenceElement.attributeValue("preloaded"));
        DLFileEntryType existingFileEntryType = !preloaded ? (DLFileEntryType)this.fetchMissingReference(uuid, groupId) : this.fetchExistingFileEntryTypeWithParentGroups(uuid, groupId, fileEntryTypeKey, preloaded);
        if (existingFileEntryType == null) {
            return;
        }
        Map fileEntryTypeIds = portletDataContext.getNewPrimaryKeysMap(DLFileEntryType.class);
        long fileEntryTypeId = GetterUtil.getLong((String)referenceElement.attributeValue("class-pk"));
        fileEntryTypeIds.put(fileEntryTypeId, existingFileEntryType.getFileEntryTypeId());
    }

    protected void doImportStagedModel(PortletDataContext portletDataContext, DLFileEntryType fileEntryType) throws Exception {
        long userId = portletDataContext.getUserId(fileEntryType.getUserUuid());
        List ddmStructureReferenceElements = portletDataContext.getReferenceElements((StagedModel)fileEntryType, com.liferay.dynamic.data.mapping.model.DDMStructure.class);
        long[] ddmStructureIdsArray = new long[ddmStructureReferenceElements.size()];
        Map ddmStructureIds = portletDataContext.getNewPrimaryKeysMap(com.liferay.dynamic.data.mapping.model.DDMStructure.class);
        for (int i = 0; i < ddmStructureReferenceElements.size(); ++i) {
            Element ddmStructureReferenceElement = (Element)ddmStructureReferenceElements.get(i);
            long ddmStructureId = GetterUtil.getLong((String)ddmStructureReferenceElement.attributeValue("class-pk"));
            ddmStructureIdsArray[i] = MapUtil.getLong((Map)ddmStructureIds, (long)ddmStructureId);
        }
        ServiceContext serviceContext = portletDataContext.createServiceContext((StagedModel)fileEntryType);
        DLFileEntryType importedDLFileEntryType = null;
        Element element = portletDataContext.getImportDataStagedModelElement((StagedModel)fileEntryType);
        boolean preloaded = GetterUtil.getBoolean((String)element.attributeValue("preloaded"));
        if (portletDataContext.isDataStrategyMirror()) {
            DLFileEntryType existingDLFileEntryType = this.fetchExistingFileEntryType(fileEntryType.getUuid(), portletDataContext.getScopeGroupId(), fileEntryType.getFileEntryTypeKey(), preloaded);
            if (existingDLFileEntryType == null) {
                serviceContext.setUuid(fileEntryType.getUuid());
                importedDLFileEntryType = this._dlFileEntryTypeLocalService.addFileEntryType(userId, portletDataContext.getScopeGroupId(), fileEntryType.getFileEntryTypeKey(), fileEntryType.getNameMap(), fileEntryType.getDescriptionMap(), ddmStructureIdsArray, serviceContext);
            } else {
                this._dlFileEntryTypeLocalService.updateFileEntryType(userId, existingDLFileEntryType.getFileEntryTypeId(), fileEntryType.getNameMap(), fileEntryType.getDescriptionMap(), ddmStructureIdsArray, serviceContext);
                importedDLFileEntryType = this._dlFileEntryTypeLocalService.fetchDLFileEntryType(existingDLFileEntryType.getFileEntryTypeId());
            }
        } else {
            importedDLFileEntryType = this._dlFileEntryTypeLocalService.addFileEntryType(userId, portletDataContext.getScopeGroupId(), fileEntryType.getFileEntryTypeKey(), fileEntryType.getNameMap(), fileEntryType.getDescriptionMap(), ddmStructureIdsArray, serviceContext);
        }
        portletDataContext.importClassedModel((ClassedModel)fileEntryType, (ClassedModel)importedDLFileEntryType);
        if (preloaded) {
            return;
        }
        String importedDLFileEntryDDMStructureKey = DLUtil.getDDMStructureKey((DLFileEntryType)importedDLFileEntryType);
        List importedDDMStructures = importedDLFileEntryType.getDDMStructures();
        for (DDMStructure importedDDMStructure : importedDDMStructures) {
            String ddmStructureKey = importedDDMStructure.getStructureKey();
            if (!DLUtil.isAutoGeneratedDLFileEntryTypeDDMStructureKey((String)ddmStructureKey) || ddmStructureKey.equals(importedDLFileEntryDDMStructureKey)) continue;
            com.liferay.dynamic.data.mapping.model.DDMStructure ddmStructure = this._ddmStructureLocalService.getDDMStructure(importedDDMStructure.getStructureId());
            ddmStructure.setStructureKey(importedDLFileEntryDDMStructureKey);
            this._ddmStructureLocalService.updateDDMStructure(ddmStructure);
        }
    }

    protected DLFileEntryType fetchExistingFileEntryType(String uuid, long groupId, String fileEntryTypeKey, boolean preloaded) {
        DLFileEntryType existingDLFileEntryType = null;
        existingDLFileEntryType = !preloaded ? this.fetchStagedModelByUuidAndGroupId(uuid, groupId) : this._dlFileEntryTypeLocalService.fetchFileEntryType(groupId, fileEntryTypeKey);
        return existingDLFileEntryType;
    }

    protected DLFileEntryType fetchExistingFileEntryTypeWithParentGroups(String uuid, long groupId, String fileEntryTypeKey, boolean preloaded) {
        Group group = this._groupLocalService.fetchGroup(groupId);
        if (group == null) {
            return this.fetchExistingFileEntryType(uuid, groupId, fileEntryTypeKey, preloaded);
        }
        long companyId = group.getCompanyId();
        while (group != null) {
            DLFileEntryType existingDLFileEntryType = this.fetchExistingFileEntryType(uuid, group.getGroupId(), fileEntryTypeKey, preloaded);
            if (existingDLFileEntryType != null) {
                return existingDLFileEntryType;
            }
            group = group.getParentGroup();
        }
        Group companyGroup = this._groupLocalService.fetchCompanyGroup(companyId);
        if (companyGroup == null) {
            return null;
        }
        return this.fetchExistingFileEntryType(uuid, companyGroup.getGroupId(), fileEntryTypeKey, preloaded);
    }

    @Reference(unbind="-")
    protected void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryTypeLocalService(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    @Reference(unbind="-")
    protected void setUserLocalService(UserLocalService userLocalService) {
        this._userLocalService = userLocalService;
    }

    @Reference(target="(&(verify.process.name=com.liferay.document.library.service))", unbind="-")
    protected void setVerifyProcessCompletionMarker(Object object) {
    }
}

