/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection.action;

import com.liferay.asset.kernel.model.AssetEntry;
import com.liferay.asset.kernel.model.AssetRenderer;
import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionAction;
import com.liferay.document.library.bulk.selection.EditTagsBulkSelectionAction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionCheckerFactoryUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portlet.asset.util.AssetUtil;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={BulkSelectionAction.class, EditTagsBulkSelectionAction.class, EditTagsBulkSelectionActionImpl.class})
public class EditTagsBulkSelectionActionImpl
implements EditTagsBulkSelectionAction {
    private static final Log _log = LogFactoryUtil.getLog(EditTagsBulkSelectionActionImpl.class);
    @Reference
    private AssetEntryLocalService _assetEntryLocalService;

    public void execute(User user, BulkSelection<AssetEntry> bulkSelection, Map<String, Serializable> inputMap) throws Exception {
        Set<String> toAddTagNamesSet = this._toStringSet(inputMap, "toAddTagNames");
        Set<String> toRemoveTagNamesSet = this._toStringSet(inputMap, "toRemoveTagNames");
        PermissionChecker permissionChecker = PermissionCheckerFactoryUtil.create((User)user);
        bulkSelection.forEach(assetEntry -> {
            block5: {
                try {
                    if (!this._hasEditPermission((AssetEntry)assetEntry, permissionChecker)) {
                        return;
                    }
                    String[] newTagNames = new String[]{};
                    if (SetUtil.isNotEmpty((Set)toAddTagNamesSet)) {
                        newTagNames = (String[])inputMap.get("toAddTagNames");
                    }
                    if (MapUtil.getBoolean((Map)inputMap, (String)"append")) {
                        Set currentTagNamesSet = SetUtil.fromArray((Object[])assetEntry.getTagNames());
                        currentTagNamesSet.removeAll(toRemoveTagNamesSet);
                        currentTagNamesSet.addAll(toAddTagNamesSet);
                        currentTagNamesSet.removeIf(tagName -> !AssetUtil.isValidWord((String)tagName));
                        newTagNames = currentTagNamesSet.toArray(new String[0]);
                    }
                    this._assetEntryLocalService.updateEntry(assetEntry.getUserId(), assetEntry.getGroupId(), assetEntry.getClassName(), assetEntry.getClassPK(), assetEntry.getCategoryIds(), newTagNames);
                }
                catch (PortalException portalException) {
                    if (!_log.isWarnEnabled()) break block5;
                    _log.warn((Object)portalException, (Throwable)portalException);
                }
            }
        });
    }

    private boolean _hasEditPermission(AssetEntry assetEntry, PermissionChecker permissionChecker) throws PortalException {
        AssetRenderer assetRenderer = assetEntry.getAssetRenderer();
        if (assetRenderer != null) {
            return assetRenderer.hasEditPermission(permissionChecker);
        }
        return BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)assetEntry.getGroupId(), (String)assetEntry.getClassName(), (long)assetEntry.getClassPK(), (String)"UPDATE");
    }

    private Set<String> _toStringSet(Map<String, Serializable> map, String key) {
        try {
            return SetUtil.fromArray((Object[])((String[])map.getOrDefault(key, (Serializable)new String[0])));
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return SetUtil.fromArray((Object[])new String[0]);
        }
    }
}

