/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search.spi.model.query.contributor;

import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.dynamic.data.mapping.util.DDMIndexer;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.BooleanClauseOccur;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.search.filter.Filter;
import com.liferay.portal.kernel.search.filter.QueryFilter;
import com.liferay.portal.kernel.search.filter.TermsFilter;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.search.spi.model.query.contributor.ModelPreFilterContributor;
import com.liferay.portal.search.spi.model.registrar.ModelSearchSettings;
import java.io.Serializable;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelPreFilterContributor.class})
public class DLFileEntryModelPreFilterContributor
implements ModelPreFilterContributor {
    @Reference
    protected DDMIndexer ddmIndexer;
    @Reference
    protected DDMStructureManager ddmStructureManager;
    protected RelatedEntryIndexer relatedEntryIndexer = new BaseRelatedEntryIndexer();
    @Reference(target="(model.pre.filter.contributor.id=WorkflowStatus)")
    protected ModelPreFilterContributor workflowStatusModelPreFilterContributor;

    public void contribute(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this.addAttachmentFilter(booleanFilter, searchContext);
        this.addClassTypeIdsFilter(booleanFilter, modelSearchSettings, searchContext);
        this.addDDMFieldFilter(booleanFilter, searchContext);
        this.addWorkflowStatusFilter(booleanFilter, modelSearchSettings, searchContext);
        this.addHiddenFilter(booleanFilter, searchContext);
        this.addMimeTypesFilter(booleanFilter, searchContext);
    }

    protected void addAttachmentFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        if (!searchContext.isIncludeAttachments()) {
            return;
        }
        try {
            this.relatedEntryIndexer.addRelatedClassNames(booleanFilter, searchContext);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    protected void addClassTypeIdsFilter(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        long[] classTypeIds = searchContext.getClassTypeIds();
        if (ArrayUtil.isEmpty((long[])classTypeIds)) {
            return;
        }
        TermsFilter termsFilter = new TermsFilter("classTypeId");
        termsFilter.addValues(ArrayUtil.toStringArray((long[])classTypeIds));
        booleanFilter.add((Filter)termsFilter, BooleanClauseOccur.MUST);
    }

    protected void addDDMFieldFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        try {
            String ddmStructureFieldName = (String)((Object)searchContext.getAttribute("ddmStructureFieldName"));
            Serializable ddmStructureFieldValue = searchContext.getAttribute("ddmStructureFieldValue");
            if (Validator.isNotNull((String)ddmStructureFieldName) && Validator.isNotNull((Object)ddmStructureFieldValue)) {
                QueryFilter queryFilter = this.ddmIndexer.createFieldValueQueryFilter(ddmStructureFieldName, ddmStructureFieldValue, searchContext.getLocale());
                booleanFilter.add((Filter)queryFilter, BooleanClauseOccur.MUST);
            }
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    protected void addHiddenFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        if ((ArrayUtil.isEmpty((long[])searchContext.getFolderIds()) || ArrayUtil.contains((long[])searchContext.getFolderIds(), (long)0L)) && !searchContext.isIncludeAttachments()) {
            booleanFilter.addRequiredTerm("hidden", false);
        }
    }

    protected void addMimeTypesFilter(BooleanFilter booleanFilter, SearchContext searchContext) {
        Object[] mimeTypes = (String[])searchContext.getAttribute("mimeTypes");
        if (ArrayUtil.isNotEmpty((Object[])mimeTypes)) {
            BooleanFilter mimeTypesBooleanFilter = new BooleanFilter();
            for (Object mimeType : mimeTypes) {
                mimeTypesBooleanFilter.addTerm("mimeType", StringUtil.replace((String)mimeType, (char)'/', (char)'_'));
            }
            booleanFilter.add((Filter)mimeTypesBooleanFilter, BooleanClauseOccur.MUST);
        }
    }

    protected void addWorkflowStatusFilter(BooleanFilter booleanFilter, ModelSearchSettings modelSearchSettings, SearchContext searchContext) {
        this.workflowStatusModelPreFilterContributor.contribute(booleanFilter, modelSearchSettings, searchContext);
    }
}

