/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.comment.Comment;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.search.BaseRelatedEntryIndexer;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.filter.BooleanFilter;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"related.entry.indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={RelatedEntryIndexer.class})
public class DLFileEntryRelatedEntryIndexer
implements RelatedEntryIndexer {
    @Reference
    protected DLAppLocalService dlAppLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryRelatedEntryIndexer.class);
    private final RelatedEntryIndexer _relatedEntryIndexer = new BaseRelatedEntryIndexer();

    public void addRelatedClassNames(BooleanFilter contextBooleanFilter, SearchContext searchContext) throws Exception {
        this._relatedEntryIndexer.addRelatedClassNames(contextBooleanFilter, searchContext);
    }

    public void addRelatedEntryFields(Document document, Object obj) throws Exception {
        Comment comment = (Comment)obj;
        FileEntry fileEntry = null;
        try {
            fileEntry = this.dlAppLocalService.getFileEntry(comment.getClassPK());
        }
        catch (Exception exception) {
            return;
        }
        if (fileEntry instanceof LiferayFileEntry) {
            DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
        }
    }

    public boolean isVisibleRelatedEntry(long classPK, int status) throws Exception {
        try {
            DLFileEntry dlFileEntry;
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(classPK);
            if (fileEntry instanceof LiferayFileEntry && (dlFileEntry = (DLFileEntry)fileEntry.getModel()).isInHiddenFolder()) {
                Indexer indexer = IndexerRegistryUtil.getIndexer((String)dlFileEntry.getClassName());
                return indexer.isVisible(dlFileEntry.getClassPK(), status);
            }
        }
        catch (Exception exception) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to get file entry", (Throwable)exception);
            }
            return false;
        }
        return true;
    }

    public void updateFullQuery(SearchContext searchContext) {
        if (searchContext.isIncludeAttachments()) {
            searchContext.addFullQueryEntryClassName(DLFileEntry.class.getName());
        }
    }
}

