/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.configuration.DLConfiguration;
import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.versioning.VersionPurger;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.transaction.TransactionCommitCallbackUtil;
import com.liferay.portal.repository.capabilities.util.DLAppServiceAdapter;
import com.liferay.portal.repository.util.LocalRepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapperAware;
import java.io.File;
import java.io.InputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"repository.class.name=com.liferay.portal.repository.liferayrepository.LiferayRepository"}, service={Capability.class})
public class LiferayVersioningCapability
implements Capability,
RepositoryWrapperAware {
    @Reference
    private DLConfiguration _dlConfiguration;
    private ServiceTrackerList<VersionPurger.VersionPurgedListener, VersionPurger.VersionPurgedListener> _versionPurgedListeners;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    private volatile VersionPurger _versionPurger;

    public LocalRepository wrapLocalRepository(LocalRepository localRepository) {
        final DLAppServiceAdapter dlAppServiceAdapter = DLAppServiceAdapter.create((DocumentRepository)localRepository);
        return new LocalRepositoryWrapper(localRepository){

            public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
                super.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
                LiferayVersioningCapability.this._purgeVersions(dlAppServiceAdapter, super.getFileEntry(fileEntryId));
            }

            public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
                return LiferayVersioningCapability.this._purgeVersions(dlAppServiceAdapter, super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext));
            }

            public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
                return LiferayVersioningCapability.this._purgeVersions(dlAppServiceAdapter, super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, is, size, serviceContext));
            }
        };
    }

    public Repository wrapRepository(Repository repository) {
        final DLAppServiceAdapter dlAppServiceAdapter = DLAppServiceAdapter.create((DocumentRepository)repository);
        return new RepositoryWrapper(repository){

            public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
                super.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
                LiferayVersioningCapability.this._purgeVersions(dlAppServiceAdapter, super.getFileEntry(fileEntryId));
            }

            public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
                return LiferayVersioningCapability.this._purgeVersions(dlAppServiceAdapter, super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext));
            }

            public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
                return LiferayVersioningCapability.this._purgeVersions(dlAppServiceAdapter, super.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, is, size, serviceContext));
            }
        };
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._versionPurgedListeners = ServiceTrackerListFactory.open((BundleContext)bundleContext, VersionPurger.VersionPurgedListener.class);
    }

    @Deactivate
    protected void deactivate() {
        this._versionPurgedListeners.close();
    }

    private FileEntry _purgeVersions(DLAppServiceAdapter dlAppServiceAdapter, FileEntry fileEntry) {
        if (this._versionPurger == null || fileEntry.isCheckedOut()) {
            return fileEntry;
        }
        TransactionCommitCallbackUtil.registerCallback(() -> {
            for (FileVersion fileVersion : this._versionPurger.getToPurgeFileVersions(fileEntry)) {
                for (VersionPurger.VersionPurgedListener versionPurgedListener : this._versionPurgedListeners) {
                    versionPurgedListener.versionPurged(fileVersion);
                }
                dlAppServiceAdapter.deleteFileVersion(fileVersion.getFileVersionId());
            }
            return null;
        });
        return fileEntry;
    }
}

