/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.convert.document.library;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileVersionLocalService;
import com.liferay.document.library.kernel.store.Store;
import com.liferay.portal.convert.documentlibrary.DLStoreConvertProcess;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.util.MaintenanceUtil;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={DLStoreConvertProcess.class})
public class DLFileVersionDLStoreConvertProcess
implements DLStoreConvertProcess {
    private static final Log _log = LogFactoryUtil.getLog(DLFileVersionDLStoreConvertProcess.class);
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFileVersionLocalService _dlFileVersionLocalService;

    public void copy(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, false);
    }

    public void move(Store sourceStore, Store targetStore) throws PortalException {
        this._transfer(sourceStore, targetStore, true);
    }

    private void _transfer(Store sourceStore, Store targetStore, boolean delete) throws PortalException {
        int count = this._dlFileVersionLocalService.getDLFileVersionsCount();
        MaintenanceUtil.appendStatus((String)("Migrating " + count + " documents and media files"));
        ActionableDynamicQuery actionableDynamicQuery = this._dlFileVersionLocalService.getActionableDynamicQuery();
        actionableDynamicQuery.setPerformActionMethod(dlFileVersion -> {
            DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(dlFileVersion.getFileEntryId());
            if (dlFileEntry == null) {
                return;
            }
            long repositoryId = DLFolderConstants.getDataRepositoryId((long)dlFileVersion.getRepositoryId(), (long)dlFileVersion.getFolderId());
            try {
                if (delete) {
                    sourceStore.moveFileToStore(dlFileVersion.getCompanyId(), repositoryId, dlFileEntry.getName(), dlFileVersion.getVersion(), targetStore);
                } else {
                    sourceStore.copyFileToStore(dlFileVersion.getCompanyId(), repositoryId, dlFileEntry.getName(), dlFileVersion.getVersion(), targetStore);
                }
            }
            catch (Exception exception) {
                _log.error((Object)("Unable to migrate " + dlFileEntry.getName()), (Throwable)exception);
            }
        });
        actionableDynamicQuery.performActions();
    }
}

