/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.bulk.selection;

import com.liferay.bulk.selection.BulkSelection;
import com.liferay.bulk.selection.BulkSelectionFactory;
import com.liferay.bulk.selection.EmptyBulkSelection;
import com.liferay.document.library.internal.bulk.selection.FolderFolderBulkSelection;
import com.liferay.document.library.internal.bulk.selection.MultipleFolderBulkSelection;
import com.liferay.document.library.internal.bulk.selection.SingleFolderBulkSelection;
import com.liferay.document.library.internal.bulk.selection.util.BulkSelectionFactoryUtil;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.portal.kernel.repository.RepositoryProvider;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"model.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={BulkSelectionFactory.class, FolderBulkSelectionFactory.class})
public class FolderBulkSelectionFactory
implements BulkSelectionFactory<Folder> {
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private RepositoryProvider _repositoryProvider;

    public BulkSelection<Folder> create(Map<String, String[]> parameterMap) {
        if (BulkSelectionFactoryUtil.isSelectAll(parameterMap)) {
            return new FolderFolderBulkSelection(BulkSelectionFactoryUtil.getRepositoryId(parameterMap), BulkSelectionFactoryUtil.getFolderId(parameterMap), parameterMap, this._repositoryProvider, this._dlAppService);
        }
        if (!parameterMap.containsKey("rowIdsFolder")) {
            return new EmptyBulkSelection();
        }
        String[] values = parameterMap.get("rowIdsFolder");
        return this._getFolderSelection(values, parameterMap);
    }

    private BulkSelection<Folder> _getFolderSelection(String[] values, Map<String, String[]> parameterMap) {
        long[] folderIds;
        if (values.length == 1) {
            values = StringUtil.split((String)values[0]);
        }
        if ((folderIds = GetterUtil.getLongValues((String[])values)).length == 1) {
            return new SingleFolderBulkSelection(folderIds[0], parameterMap, this._dlAppService);
        }
        return new MultipleFolderBulkSelection(folderIds, parameterMap, this._dlAppService);
    }
}

