/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.trash;

import com.liferay.asset.kernel.AssetRendererFactoryRegistryUtil;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.document.library.internal.trash.DLBaseTrashHandler;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.ContainerModel;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.repository.DocumentRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.capabilities.UnsupportedCapabilityException;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionThreadLocal;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.trash.TrashHandler;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.trash.kernel.exception.RestoreEntryException;
import com.liferay.trash.kernel.model.TrashEntry;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.document.library.kernel.model.DLFolder"}, service={TrashHandler.class})
public class DLFolderTrashHandler
extends DLBaseTrashHandler {
    private static final Log _log = LogFactoryUtil.getLog(DLFolderTrashHandler.class);
    private DLAppLocalService _dlAppLocalService;
    private DLFileEntryLocalService _dlFileEntryLocalService;
    private DLFolderLocalService _dlFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.Folder)")
    private ModelResourcePermission<Folder> _folderModelResourcePermission;

    public void checkRestorableEntry(long classPK, long containerModelId, String newName) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        this.checkRestorableEntry(classPK, 0L, containerModelId, dlFolder.getName(), newName);
    }

    public void checkRestorableEntry(TrashEntry trashEntry, long containerModelId, String newName) throws PortalException {
        this.checkRestorableEntry(trashEntry.getClassPK(), trashEntry.getEntryId(), containerModelId, trashEntry.getTypeSettingsProperty("title"), newName);
    }

    public void deleteTrashEntry(long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        TrashCapability trashCapability = (TrashCapability)documentRepository.getCapability(TrashCapability.class);
        Folder folder = documentRepository.getFolder(classPK);
        trashCapability.deleteFolder(folder);
    }

    public String getClassName() {
        return DLFolder.class.getName();
    }

    public String getDeleteMessage() {
        return "found-in-deleted-folder-x";
    }

    public ContainerModel getParentContainerModel(long classPK) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        long parentFolderId = dlFolder.getParentFolderId();
        if (parentFolderId <= 0L) {
            return null;
        }
        return this.getContainerModel(parentFolderId);
    }

    public String getRestoreContainedModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        return DLUtil.getDLFolderControlPanelLink((PortletRequest)portletRequest, (long)dlFolder.getFolderId());
    }

    public String getRestoreContainerModelLink(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        return DLUtil.getDLFolderControlPanelLink((PortletRequest)portletRequest, (long)dlFolder.getParentFolderId());
    }

    public String getRestoreMessage(PortletRequest portletRequest, long classPK) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        return DLUtil.getAbsolutePath((PortletRequest)portletRequest, (long)dlFolder.getParentFolderId());
    }

    public String getSubcontainerModelName() {
        return "folder";
    }

    public String getSystemEventClassName() {
        return DLFolderConstants.getClassName();
    }

    public TrashedModel getTrashedModel(long classPK) {
        try {
            return this.getDLFolder(classPK);
        }
        catch (PortalException | UnsupportedCapabilityException e) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)e, e);
            }
            return null;
        }
    }

    public TrashRenderer getTrashRenderer(long classPK) throws PortalException {
        AssetRendererFactory assetRendererFactory = AssetRendererFactoryRegistryUtil.getAssetRendererFactoryByClassName((String)DLFolder.class.getName());
        return (TrashRenderer)assetRendererFactory.getAssetRenderer(classPK);
    }

    public boolean hasTrashPermission(PermissionChecker permissionChecker, long groupId, long classPK, String trashActionId) throws PortalException {
        if (trashActionId.equals("MOVE")) {
            return ModelResourcePermissionHelper.contains(this._folderModelResourcePermission, (PermissionChecker)permissionChecker, (long)groupId, (long)classPK, (String)"ADD_FOLDER");
        }
        return super.hasTrashPermission(permissionChecker, groupId, classPK, trashActionId);
    }

    public boolean isContainerModel() {
        return true;
    }

    public boolean isMovable(long classPK) throws PortalException {
        DLFolder parentFolder;
        DLFolder dlFolder = this.fetchDLFolder(classPK);
        return dlFolder.getParentFolderId() > 0L && ((parentFolder = this._dlFolderLocalService.fetchFolder(dlFolder.getParentFolderId())) == null || parentFolder.isInTrash());
    }

    public boolean isRestorable(long classPK) throws PortalException {
        DLFolder dlFolder = this.fetchDLFolder(classPK);
        if (dlFolder == null || dlFolder.getParentFolderId() > 0L && this._dlFolderLocalService.fetchFolder(dlFolder.getParentFolderId()) == null) {
            return false;
        }
        if (!this.hasTrashPermission(PermissionThreadLocal.getPermissionChecker(), dlFolder.getGroupId(), classPK, "RESTORE")) {
            return false;
        }
        return !dlFolder.isInTrashContainer();
    }

    public void moveEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        this._dlAppLocalService.moveFolder(userId, classPK, containerModelId, serviceContext);
    }

    public void moveTrashEntry(long userId, long classPK, long containerModelId, ServiceContext serviceContext) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        TrashCapability trashCapability = (TrashCapability)documentRepository.getCapability(TrashCapability.class);
        Folder folder = documentRepository.getFolder(classPK);
        Folder destinationFolder = null;
        if (containerModelId != 0L) {
            destinationFolder = documentRepository.getFolder(containerModelId);
        }
        trashCapability.moveFolderFromTrash(userId, folder, destinationFolder, serviceContext);
    }

    public void restoreTrashEntry(long userId, long classPK) throws PortalException {
        DocumentRepository documentRepository = this.getDocumentRepository(classPK);
        TrashCapability trashCapability = (TrashCapability)documentRepository.getCapability(TrashCapability.class);
        Folder folder = documentRepository.getFolder(classPK);
        trashCapability.restoreFolderFromTrash(userId, folder);
    }

    public void updateTitle(long classPK, String name) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        dlFolder.setName(name);
        this._dlFolderLocalService.updateDLFolder(dlFolder);
    }

    protected void checkRestorableEntry(long classPK, long trashEntryId, long containerModelId, String originalTitle, String newName) throws PortalException {
        DLFolder duplicateDLFolder;
        DLFolder dlFolder = this.getDLFolder(classPK);
        if (containerModelId == -1L) {
            containerModelId = 0L;
        }
        if (Validator.isNotNull((String)newName)) {
            originalTitle = newName;
        }
        if ((duplicateDLFolder = this._dlFolderLocalService.fetchFolder(dlFolder.getGroupId(), containerModelId, originalTitle)) != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateDLFolder.getFolderId());
            ree.setOldName(duplicateDLFolder.getName());
            ree.setTrashEntryId(trashEntryId);
            throw ree;
        }
        DLFileEntry duplicateDLFileEntry = this._dlFileEntryLocalService.fetchFileEntry(dlFolder.getGroupId(), containerModelId, originalTitle);
        if (duplicateDLFileEntry != null) {
            RestoreEntryException ree = new RestoreEntryException(1);
            ree.setDuplicateEntryId(duplicateDLFileEntry.getFileEntryId());
            ree.setOldName(duplicateDLFileEntry.getTitle());
            ree.setOverridable(false);
            ree.setTrashEntryId(trashEntryId);
            throw ree;
        }
    }

    @Override
    protected DocumentRepository getDocumentRepository(long classPK) throws PortalException {
        LocalRepository localRepository = RepositoryProviderUtil.getFolderLocalRepository((long)classPK);
        if (!localRepository.isCapabilityProvided(TrashCapability.class)) {
            throw new UnsupportedCapabilityException(TrashCapability.class, "Repository " + localRepository.getRepositoryId());
        }
        return localRepository;
    }

    protected boolean hasPermission(PermissionChecker permissionChecker, long classPK, String actionId) throws PortalException {
        DLFolder dlFolder = this.getDLFolder(classPK);
        if (dlFolder.isInHiddenFolder() && actionId.equals("VIEW")) {
            return false;
        }
        return this._dlFolderModelResourcePermission.contains(permissionChecker, (ClassedModel)dlFolder, actionId);
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFileEntryLocalService(DLFileEntryLocalService dlFileEntryLocalService) {
        this._dlFileEntryLocalService = dlFileEntryLocalService;
    }

    @Reference(unbind="-")
    protected void setDLFolderLocalService(DLFolderLocalService dlFolderLocalService) {
        this._dlFolderLocalService = dlFolderLocalService;
    }
}

