/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.security.permission.resource;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryModel;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.kernel.staging.permission.StagingPermission;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.ResourcePermissionCheckerUtil;
import com.liferay.portal.kernel.security.permission.resource.DynamicInheritancePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionLogic;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.StagedModelPermissionLogic;
import com.liferay.portal.kernel.service.WorkflowInstanceLinkLocalService;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.kernel.workflow.WorkflowInstanceManager;
import com.liferay.portal.kernel.workflow.permission.WorkflowPermission;
import com.liferay.portal.util.PropsValues;
import java.util.Dictionary;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={})
public class DLFileEntryModelResourcePermissionRegistrar {
    @Reference
    private DLFileEntryLocalService _dlFileEntryLocalService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private ModelResourcePermission<DLFolder> _dlFolderModelResourcePermission;
    @Reference(target="(resource.name=com.liferay.document.library)")
    private PortletResourcePermission _portletResourcePermission;
    private ServiceRegistration<ModelResourcePermission> _serviceRegistration;
    @Reference
    private StagingPermission _stagingPermission;
    @Reference
    private WorkflowInstanceLinkLocalService _workflowInstanceLinkLocalService;
    @Reference
    private WorkflowInstanceManager _workflowInstanceManager;
    @Reference
    private WorkflowPermission _workflowPermission;

    @Activate
    public void activate(BundleContext bundleContext) {
        HashMapDictionary properties = new HashMapDictionary();
        properties.put("model.class.name", DLFileEntry.class.getName());
        this._serviceRegistration = bundleContext.registerService(ModelResourcePermission.class, (Object)ModelResourcePermissionFactory.create(DLFileEntry.class, DLFileEntryModel::getFileEntryId, arg_0 -> ((DLFileEntryLocalService)this._dlFileEntryLocalService).getDLFileEntry(arg_0), (PortletResourcePermission)this._portletResourcePermission, (modelResourcePermission, consumer) -> {
            consumer.accept(new StagedModelPermissionLogic(this._stagingPermission, "com_liferay_document_library_web_portlet_DLPortlet", DLFileEntryModel::getFileEntryId));
            consumer.accept(new DLFileEntryWorkflowedModelPermissionLogic(modelResourcePermission));
            consumer.accept((permissionChecker, name, fileEntry, actionId) -> {
                String className = fileEntry.getClassName();
                long classPK = fileEntry.getClassPK();
                if (Validator.isNull((String)className) || classPK <= 0L) {
                    return null;
                }
                Boolean hasResourcePermission = ResourcePermissionCheckerUtil.containsResourcePermission((PermissionChecker)permissionChecker, (String)className, (long)classPK, (String)actionId);
                if (hasResourcePermission != null && !hasResourcePermission.booleanValue()) {
                    return false;
                }
                Boolean hasBaseModelPermission = BaseModelPermissionCheckerUtil.containsBaseModelPermission((PermissionChecker)permissionChecker, (long)fileEntry.getGroupId(), (String)className, (long)classPK, (String)actionId);
                if (hasBaseModelPermission != null && !hasBaseModelPermission.booleanValue()) {
                    return false;
                }
                return null;
            });
            if (PropsValues.PERMISSIONS_VIEW_DYNAMIC_INHERITANCE) {
                consumer.accept(new DynamicInheritancePermissionLogic(this._dlFolderModelResourcePermission, this._getFetchParentFunction(), true));
            }
        }), (Dictionary)properties);
    }

    @Deactivate
    public void deactivate() {
        this._serviceRegistration.unregister();
    }

    private UnsafeFunction<DLFileEntry, DLFolder, PortalException> _getFetchParentFunction() {
        return fileEntry -> {
            long folderId = fileEntry.getFolderId();
            if (0L == folderId) {
                return null;
            }
            if (fileEntry.isInTrash()) {
                return this._dlFolderLocalService.fetchDLFolder(folderId);
            }
            return this._dlFolderLocalService.getFolder(folderId);
        };
    }

    private class DLFileEntryWorkflowedModelPermissionLogic
    implements ModelResourcePermissionLogic<DLFileEntry> {
        private final ModelResourcePermission<DLFileEntry> _modelResourcePermission;

        public Boolean contains(PermissionChecker permissionChecker, String name, DLFileEntry dlFileEntry, String actionId) throws PortalException {
            DLFileVersion fileVersion = dlFileEntry.getFileVersion();
            if (fileVersion.isDraft() || fileVersion.isScheduled()) {
                if (actionId.equals("VIEW") && !this._modelResourcePermission.contains(permissionChecker, (ClassedModel)dlFileEntry, "UPDATE")) {
                    return false;
                }
            } else if (fileVersion.isPending()) {
                Boolean hasPermission = DLFileEntryModelResourcePermissionRegistrar.this._workflowPermission.hasPermission(permissionChecker, fileVersion.getGroupId(), name, fileVersion.getFileVersionId(), actionId);
                if (hasPermission != null) {
                    return (boolean)hasPermission;
                }
                boolean hasOwnerPermission = permissionChecker.hasOwnerPermission(dlFileEntry.getCompanyId(), name, dlFileEntry.getFileEntryId(), dlFileEntry.getUserId(), actionId);
                if (!hasOwnerPermission) {
                    return false;
                }
            }
            return null;
        }

        private DLFileEntryWorkflowedModelPermissionLogic(ModelResourcePermission<DLFileEntry> modelResourcePermission) {
            this._modelResourcePermission = modelResourcePermission;
        }
    }
}

