/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.search.spi.model.result.contributor.ModelVisibilityContributor;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelVisibilityContributor.class})
public class DLFileEntryModelVisibilityContributor
implements ModelVisibilityContributor {
    @Reference
    protected DLAppLocalService dlAppLocalService;
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelVisibilityContributor.class);

    public boolean isVisible(long classPK, int status) {
        FileVersion fileVersion = this.getFileVersion(classPK);
        if (fileVersion == null) {
            return false;
        }
        return this.isVisible(fileVersion.getStatus(), status);
    }

    protected FileVersion getFileVersion(long classPK) {
        try {
            FileEntry fileEntry = this.dlAppLocalService.getFileEntry(classPK);
            return fileEntry.getFileVersion();
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return null;
        }
    }

    protected boolean isVisible(int entryStatus, int queryStatus) {
        return queryStatus != -1 && entryStatus == queryStatus || entryStatus != 8;
    }
}

