/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.search;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.document.library.security.io.InputStreamSanitizer;
import com.liferay.dynamic.data.mapping.kernel.DDMFormValues;
import com.liferay.dynamic.data.mapping.kernel.DDMStructureManager;
import com.liferay.dynamic.data.mapping.kernel.StorageEngineManager;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.DocumentHelper;
import com.liferay.portal.kernel.search.Field;
import com.liferay.portal.kernel.search.RelatedEntryIndexer;
import com.liferay.portal.kernel.search.RelatedEntryIndexerRegistry;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import com.liferay.portal.search.spi.model.index.contributor.ModelDocumentContributor;
import com.liferay.portal.util.PrefsPropsUtil;
import com.liferay.portal.util.PropsValues;
import com.liferay.trash.TrashHelper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"indexer.class.name=com.liferay.document.library.kernel.model.DLFileEntry"}, service={ModelDocumentContributor.class})
public class DLFileEntryModelDocumentContributor
implements ModelDocumentContributor<DLFileEntry> {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryModelDocumentContributor.class);
    @Reference
    private DDMStructureManager _ddmStructureManager;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private InputStreamSanitizer _inputStreamSanitizer;
    @Reference
    private Portal _portal;
    @Reference
    private RelatedEntryIndexerRegistry _relatedEntryIndexerRegistry;
    @Reference
    private StorageEngineManager _storageEngineManager;
    @Reference
    private TrashHelper _trashHelper;

    public void contribute(Document document, DLFileEntry dlFileEntry) {
        DLFileVersion dlFileVersion;
        InputStream is;
        boolean indexContent;
        block26: {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Indexing document " + dlFileEntry));
            }
            indexContent = true;
            Object[] ignoreExtensions = PrefsPropsUtil.getStringArray((String)"dl.file.indexing.ignore.extensions", (String)",");
            if (ArrayUtil.contains((Object[])ignoreExtensions, (Object)("." + dlFileEntry.getExtension()))) {
                indexContent = false;
            }
            is = null;
            if (indexContent) {
                try {
                    dlFileVersion = dlFileEntry.getFileVersion();
                    is = this._inputStreamSanitizer.sanitize(dlFileVersion.getContentStream(false));
                }
                catch (Exception e) {
                    if (!_log.isDebugEnabled()) break block26;
                    _log.debug((Object)"Unable to retrieve document stream", (Throwable)e);
                }
            }
        }
        try {
            List relatedEntryIndexers;
            dlFileVersion = dlFileEntry.getFileVersion();
            if (indexContent) {
                if (is != null) {
                    try {
                        Locale defaultLocale = this._portal.getSiteDefaultLocale(dlFileEntry.getGroupId());
                        String localizedField = Field.getLocalizedName((String)defaultLocale.toString(), (String)"content");
                        document.addFile(localizedField, is, dlFileEntry.getTitle(), PropsValues.DL_FILE_INDEXING_MAX_SIZE);
                    }
                    catch (IOException ioe) {
                        if (_log.isWarnEnabled()) {
                            _log.warn((Object)"Unable to index content", (Throwable)ioe);
                        }
                    }
                } else if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Document " + dlFileEntry + " does not have any content"));
                }
            }
            document.addKeyword("classTypeId", dlFileEntry.getFileEntryTypeId());
            document.addText("description", dlFileEntry.getDescription());
            document.addKeyword("folderId", dlFileEntry.getFolderId());
            document.addKeyword("hidden", dlFileEntry.isInHiddenFolder());
            document.addKeyword("status", dlFileVersion.getStatus());
            String title = dlFileEntry.getTitle();
            if (dlFileEntry.isInTrash()) {
                title = this._trashHelper.getOriginalTitle(title);
            }
            document.addText("title", title);
            document.addKeyword("treePath", StringUtil.split((String)dlFileEntry.getTreePath(), (char)'/'));
            document.addKeyword("dataRepositoryId", dlFileEntry.getDataRepositoryId());
            document.addText("ddmContent", this._extractDDMContent(dlFileVersion, LocaleUtil.getSiteDefault()));
            document.addKeyword("extension", dlFileEntry.getExtension());
            document.addKeyword("fileEntryTypeId", dlFileEntry.getFileEntryTypeId());
            document.addTextSortable("fileExtension", dlFileEntry.getExtension());
            document.addTextSortable("mimeType", StringUtil.replace((String)dlFileEntry.getMimeType(), (char)'/', (char)'_'));
            document.addKeyword("readCount", dlFileEntry.getReadCount());
            document.addNumber("size", dlFileEntry.getSize());
            this._addFileEntryTypeAttributes(document, dlFileVersion);
            if (dlFileEntry.isInHiddenFolder() && ListUtil.isNotEmpty((List)(relatedEntryIndexers = this._relatedEntryIndexerRegistry.getRelatedEntryIndexers(dlFileEntry.getClassName())))) {
                for (RelatedEntryIndexer relatedEntryIndexer : relatedEntryIndexers) {
                    relatedEntryIndexer.addRelatedEntryFields(document, (Object)new LiferayFileEntry(dlFileEntry));
                    DocumentHelper documentHelper = new DocumentHelper(document);
                    documentHelper.setAttachmentOwnerKey(this._portal.getClassNameId(dlFileEntry.getClassName()), dlFileEntry.getClassPK());
                    document.addKeyword("relatedEntry", true);
                }
            }
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Document " + dlFileEntry + " indexed successfully"));
            }
        }
        catch (Exception e) {
            throw new SystemException((Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private void _addFileEntryTypeAttributes(Document document, DLFileVersion dlFileVersion) {
        List dlFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(dlFileVersion.getFileVersionId());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            try {
                DDMFormValues ddmFormValues = this._storageEngineManager.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
                if (ddmFormValues == null) continue;
                this._ddmStructureManager.addAttributes(dlFileEntryMetadata.getDDMStructureId(), document, ddmFormValues);
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to retrieve metadata values", (Throwable)e);
            }
        }
    }

    private String _extractDDMContent(DLFileVersion dlFileVersion, Locale locale) {
        List dlFileEntryMetadatas = this._dlFileEntryMetadataLocalService.getFileVersionFileEntryMetadatas(dlFileVersion.getFileVersionId());
        StringBundler sb = new StringBundler(dlFileEntryMetadatas.size());
        for (DLFileEntryMetadata dlFileEntryMetadata : dlFileEntryMetadatas) {
            try {
                DDMFormValues ddmFormValues = this._storageEngineManager.getDDMFormValues(dlFileEntryMetadata.getDDMStorageId());
                if (ddmFormValues == null) continue;
                sb.append(this._ddmStructureManager.extractAttributes(dlFileEntryMetadata.getDDMStructureId(), ddmFormValues, locale));
            }
            catch (Exception e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)"Unable to retrieve metadata values", (Throwable)e);
            }
        }
        return sb.toString();
    }
}

