/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.repository.capabilities;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.util.DLAppHelperThreadLocal;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.WorkflowCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.workflow.WorkflowThreadLocal;
import com.liferay.portal.repository.capabilities.WorkflowSupport;
import com.liferay.portal.repository.capabilities.util.DLFileEntryServiceAdapter;
import com.liferay.portal.repository.capabilities.util.DLFileVersionServiceAdapter;
import com.liferay.portal.repository.liferayrepository.LiferayWorkflowLocalRepositoryWrapper;
import com.liferay.portal.repository.liferayrepository.LiferayWorkflowRepositoryWrapper;
import com.liferay.portal.repository.util.RepositoryWrapperAware;

public class LiferayWorkflowCapability
implements RepositoryWrapperAware,
WorkflowCapability,
WorkflowSupport {
    private final DLFileEntryServiceAdapter _dlFileEntryServiceAdapter;
    private final DLFileVersionServiceAdapter _dlFileVersionServiceAdapter;

    public LiferayWorkflowCapability(DLFileEntryServiceAdapter dlFileEntryServiceAdapter, DLFileVersionServiceAdapter dlFileVersionServiceAdapter) {
        this._dlFileEntryServiceAdapter = dlFileEntryServiceAdapter;
        this._dlFileVersionServiceAdapter = dlFileVersionServiceAdapter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFileEntry(long userId, FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        boolean previousEnabled = WorkflowThreadLocal.isEnabled();
        if (!DLAppHelperThreadLocal.isEnabled()) {
            WorkflowThreadLocal.setEnabled((boolean)false);
        }
        try {
            FileVersion fileVersion = fileEntry.getFileVersion();
            DLUtil.startWorkflowInstance((long)userId, (DLFileVersion)((DLFileVersion)fileVersion.getModel()), (String)"add", (ServiceContext)serviceContext);
        }
        finally {
            if (!DLAppHelperThreadLocal.isEnabled()) {
                WorkflowThreadLocal.setEnabled((boolean)previousEnabled);
            }
        }
    }

    public void checkInFileEntry(long userId, FileEntry fileEntry, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        if (serviceContext.getWorkflowAction() == 1) {
            DLFileVersion latestDLFileVersion = this._dlFileVersionServiceAdapter.getLatestFileVersion(fileEntry.getFileEntryId(), false);
            DLUtil.startWorkflowInstance((long)userId, (DLFileVersion)latestDLFileVersion, (String)"update", (ServiceContext)serviceContext);
        }
    }

    public int getStatus(FileEntry fileEntry) {
        DLFileEntry dlFileEntry = (DLFileEntry)fileEntry.getModel();
        return dlFileEntry.getStatus();
    }

    public void revertFileEntry(long userId, FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        this._startWorkflowInstance(userId, fileEntry, serviceContext);
    }

    public void updateFileEntry(long userId, FileEntry fileEntry, boolean majorVersion, ServiceContext serviceContext) throws PortalException {
        this._startWorkflowInstance(userId, fileEntry, serviceContext);
    }

    public LocalRepository wrapLocalRepository(LocalRepository localRepository) {
        return new LiferayWorkflowLocalRepositoryWrapper(localRepository, (WorkflowSupport)this);
    }

    public Repository wrapRepository(Repository repository) {
        return new LiferayWorkflowRepositoryWrapper(repository, (WorkflowSupport)this);
    }

    private DLFileVersion _getWorkflowDLFileVersion(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        DLFileEntry dlFileEntry = this._dlFileEntryServiceAdapter.getDLFileEntry(fileEntryId);
        if (dlFileEntry.isCheckedOut()) {
            return null;
        }
        DLFileVersion dlFileVersion = this._dlFileVersionServiceAdapter.getLatestFileVersion(fileEntryId, true);
        if (dlFileVersion.isApproved() || serviceContext.getWorkflowAction() == 1) {
            return dlFileVersion;
        }
        return null;
    }

    private void _startWorkflowInstance(long userId, DLFileVersion dlFileVersion, ServiceContext serviceContext) throws PortalException {
        if (dlFileVersion == null) {
            return;
        }
        String syncEvent = "update";
        String version = dlFileVersion.getVersion();
        if (version.equals("1.0")) {
            syncEvent = "add";
        }
        DLUtil.startWorkflowInstance((long)userId, (DLFileVersion)dlFileVersion, (String)syncEvent, (ServiceContext)serviceContext);
    }

    private void _startWorkflowInstance(long userId, FileEntry fileEntry, ServiceContext serviceContext) throws PortalException {
        DLFileVersion dlFileVersion = this._getWorkflowDLFileVersion(fileEntry.getFileEntryId(), serviceContext);
        this._startWorkflowInstance(userId, dlFileVersion, serviceContext);
    }
}

