/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.internal.model.listener;

import com.liferay.document.library.exportimport.data.handler.DLExportableRepositoryPublisher;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.portal.kernel.exception.ModelListenerException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.BaseModelListener;
import com.liferay.portal.kernel.model.ModelListener;
import com.liferay.staging.model.listener.StagingModelListener;
import java.util.Collection;
import java.util.HashSet;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={ModelListener.class})
public class DLFolderStagingModelListener
extends BaseModelListener<DLFolder> {
    private ServiceTrackerList<DLExportableRepositoryPublisher, DLExportableRepositoryPublisher> _dlExportableRepositoryPublishers;
    @Reference
    private StagingModelListener<DLFolder> _stagingModelListener;

    public void onAfterCreate(DLFolder dlFolder) throws ModelListenerException {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(dlFolder.getGroupId());
        if (!exportableRepositoryIds.contains(dlFolder.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterCreate((BaseModel)dlFolder);
    }

    public void onAfterRemove(DLFolder dlFolder) throws ModelListenerException {
        this._stagingModelListener.onAfterRemove((BaseModel)dlFolder);
    }

    public void onAfterUpdate(DLFolder dlFolder) throws ModelListenerException {
        Collection<Long> exportableRepositoryIds = this._getExportableRepositoryIds(dlFolder.getGroupId());
        if (!exportableRepositoryIds.contains(dlFolder.getRepositoryId())) {
            return;
        }
        this._stagingModelListener.onAfterUpdate((BaseModel)dlFolder);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dlExportableRepositoryPublishers = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLExportableRepositoryPublisher.class);
    }

    @Deactivate
    protected void deactivate() {
        if (this._dlExportableRepositoryPublishers != null) {
            this._dlExportableRepositoryPublishers.close();
        }
    }

    private Collection<Long> _getExportableRepositoryIds(long groupId) {
        HashSet<Long> exportableRepositoryIds = new HashSet<Long>();
        exportableRepositoryIds.add(groupId);
        for (DLExportableRepositoryPublisher dlExportableRepositoryPublisher : this._dlExportableRepositoryPublishers) {
            dlExportableRepositoryPublisher.publish(groupId, exportableRepositoryIds::add);
        }
        return exportableRepositoryIds;
    }
}

