Liferay.Loader.define("document-library-preview-document@2.0.18/preview/js/DocumentPreviewer.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', '@frontend-taglib-clay$clayui/loading-indicator', 'frontend-js-react-web', 'frontend-js-web', 'document-library-preview-document$image-promise', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  var global = window;
  {
    Object.defineProperty(exports, "__esModule", {
      value: true
    });
    exports.default = void 0;

    var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

    var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

    var _loadingIndicator = _interopRequireDefault(require("@frontend-taglib-clay$clayui/loading-indicator"));

    var _frontendJsReactWeb = require("frontend-js-react-web");

    var _frontendJsWeb = require("frontend-js-web");

    var _imagePromise = _interopRequireDefault(require("document-library-preview-document$image-promise"));

    var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

    var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

    function _getRequireWildcardCache() {
      if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
        return cache;
      };return cache;
    }

    function _interopRequireWildcard(obj) {
      if (obj && obj.__esModule) {
        return obj;
      }if (obj === null || typeof obj !== "object" && typeof obj !== "function") {
        return { default: obj };
      }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
        return cache.get(obj);
      }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
        if (Object.prototype.hasOwnProperty.call(obj, key)) {
          var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
            Object.defineProperty(newObj, key, desc);
          } else {
            newObj[key] = obj[key];
          }
        }
      }newObj.default = obj;if (cache) {
        cache.set(obj, newObj);
      }return newObj;
    }

    function _interopRequireDefault(obj) {
      return obj && obj.__esModule ? obj : { default: obj };
    }

    /**
     * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
     *
     * This library is free software; you can redistribute it and/or modify it under
     * the terms of the GNU Lesser General Public License as published by the Free
     * Software Foundation; either version 2.1 of the License, or (at your option)
     * any later version.
     *
     * This library is distributed in the hope that it will be useful, but WITHOUT
     * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
     * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
     * details.
     */
    const KEY_CODE_ENTER = 13;
    const KEY_CODE_ESC = 27;
    /**
     * Valid list of keycodes
     * Includes backspace, tab, arrows, delete and numbers
     * @type {Array<number>}
     */

    const VALID_KEY_CODES = [8, 9, 37, 38, 39, 40, 46, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57];
    /**
     * Milisecons between goToPage calls
     * @type {number}
     */

    const WAIT_BETWEEN_GO_TO_PAGE = 250;
    /**
     * Component that creates a pdf preview
     * @review
     */

    const DocumentPreviewer = ({
      baseImageURL,
      initialPage,
      totalPages
    }) => {
      const [currentPage, setCurrentPage] = (0, _react.useState)(initialPage);
      const [currentPageLoading, setCurrentPageLoading] = (0, _react.useState)(false);
      const [expanded, setExpanded] = (0, _react.useState)(false);
      const [loadedPages] = (0, _react.useState)({
        [currentPage]: {
          loaded: true,
          pagePromise: Promise.resolve()
        }
      });
      const [nextPageDisabled, setNextPageDisabled] = (0, _react.useState)(currentPage === totalPages);
      const [previousPageDisabled, setPreviousPageDisabled] = (0, _react.useState)(currentPage === 1);
      const [showPageInput, setShowPageInput] = (0, _react.useState)(false);
      const imageContainer = (0, _react.useRef)();
      const pageInput = (0, _react.useRef)();
      const showPageInputButton = (0, _react.useRef)();
      const isMounted = (0, _frontendJsReactWeb.useIsMounted)();

      if (showPageInput) {
        setTimeout(() => {
          if (isMounted()) {
            pageInput.current.focus();
          }
        }, 100);
      }

      const loadPage = page => {
        let pagePromise = loadedPages[page] && loadedPages[page].pagePromise;

        if (!pagePromise) {
          pagePromise = (0, _imagePromise.default)("".concat(baseImageURL).concat(page)).then(() => {
            loadedPages[page].loaded = true;
          });
          loadedPages[page] = {
            loaded: false,
            pagePromise
          };
        }

        return pagePromise;
      };

      const loadAdjacentPages = (page, adjacentPageCount = 2) => {
        for (let i = 1; i <= adjacentPageCount; i++) {
          if (page + i <= totalPages) {
            loadPage(page + i);
          }

          if (page - i > 1) {
            loadPage(page - i);
          }
        }
      };

      const loadCurrentPage = (0, _frontendJsWeb.debounce)(page => {
        loadPage(page).then(() => {
          loadAdjacentPages(page);
          setCurrentPageLoading(false);
        }).catch(() => {
          setCurrentPageLoading(false);
        });
      }, WAIT_BETWEEN_GO_TO_PAGE);

      const goToPage = page => {
        setNextPageDisabled(page === totalPages);
        setPreviousPageDisabled(page === 1);

        if (!loadedPages[page] || !loadedPages[page].loaded) {
          setCurrentPageLoading(true);
          loadCurrentPage(page);
        }

        imageContainer.current.scrollTop = 0;
        setCurrentPage(page);
      };

      const processPageInput = value => {
        let pageNumber = Number.parseInt(value, 10);
        pageNumber = pageNumber ? Math.min(Math.max(1, pageNumber), totalPages) : currentPage;
        goToPage(pageNumber);
      };

      const hidePageInput = (returnFocus = true) => {
        setShowPageInput(false);

        if (returnFocus) {
          setTimeout(() => {
            if (isMounted()) {
              showPageInputButton.current.focus();
            }
          }, 100);
        }
      };

      (0, _react.useEffect)(() => {
        loadAdjacentPages(initialPage); // eslint-disable-next-line react-hooks/exhaustive-deps
      }, []);
      return (/*#__PURE__*/_react.default.createElement("div", {
          className: "preview-file"
        }, /*#__PURE__*/_react.default.createElement("div", {
          className: "preview-file-container preview-file-max-height",
          ref: imageContainer
        }, currentPageLoading ? /*#__PURE__*/_react.default.createElement(_loadingIndicator.default, null) : /*#__PURE__*/_react.default.createElement("img", {
          className: "preview-file-document ".concat(!expanded && 'preview-file-document-fit'),
          src: "".concat(baseImageURL).concat(currentPage)
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "preview-toolbar-container"
        }, /*#__PURE__*/_react.default.createElement(_button.default.Group, {
          className: "floating-bar"
        }, /*#__PURE__*/_react.default.createElement(_button.default.Group, null, /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "btn-floating-bar btn-floating-bar-text",
          onClick: () => {
            setShowPageInput(true);
          },
          ref: showPageInputButton,
          title: totalPages > 1 && Liferay.Language.get('click-to-jump-to-a-page')
        }, "".concat(Liferay.Language.get('page'), " ").concat(currentPage, " / ").concat(totalPages)), showPageInput && /*#__PURE__*/_react.default.createElement("div", {
          className: "floating-bar-input-wrapper"
        }, /*#__PURE__*/_react.default.createElement("input", {
          className: "floating-bar-input form-control form-control-sm",
          max: totalPages,
          min: "1",
          onBlur: event => {
            processPageInput(event.currentTarget.value);
            hidePageInput(false);
          },
          onKeyDown: event => {
            const code = event.keyCode || event.charCode;

            if (code === KEY_CODE_ENTER) {
              processPageInput(event.currentTarget.value);
              hidePageInput();
            } else if (code === KEY_CODE_ESC) {
              hidePageInput();
            } else if (VALID_KEY_CODES.indexOf(code) === -1) {
              event.preventDefault();
            }
          },
          placeholder: Liferay.Language.get('page-...'),
          ref: pageInput,
          type: "number"
        }))), /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "btn-floating-bar",
          disabled: previousPageDisabled,
          monospaced: true,
          onClick: () => {
            goToPage(currentPage - 1);
          },
          title: Liferay.Language.get('page-above')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "caret-top"
        })), /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "btn-floating-bar",
          disabled: nextPageDisabled,
          monospaced: true,
          onClick: () => {
            goToPage(currentPage + 1);
          },
          title: Liferay.Language.get('page-below')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: "caret-bottom"
        })), /*#__PURE__*/_react.default.createElement("div", {
          className: "separator-floating-bar"
        }), /*#__PURE__*/_react.default.createElement(_button.default, {
          className: "btn-floating-bar",
          monospaced: true,
          onClick: () => {
            setExpanded(!expanded);
          },
          title: expanded ? Liferay.Language.get('zoom-to-fit') : Liferay.Language.get('expand')
        }, /*#__PURE__*/_react.default.createElement(_icon.default, {
          symbol: expanded ? 'autosize' : 'full-size'
        })))))
      );
    };

    var _default = DocumentPreviewer;
    exports.default = _default;
    //# sourceMappingURL=DocumentPreviewer.es.js.map
  }
});
//# sourceMappingURL=DocumentPreviewer.es.js.map