/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.opener.internal.upload;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.opener.upload.UniqueFileEntryTitleProvider;
import com.liferay.petra.function.UnsafeRunnable;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.upload.UniqueFileNameProvider;
import java.util.Locale;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={UniqueFileEntryTitleProvider.class})
public class UniqueFileEntryTitleProviderImpl
implements UniqueFileEntryTitleProvider {
    private static final Log _log = LogFactoryUtil.getLog(UniqueFileEntryTitleProviderImpl.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private Language _language;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    public String provide(long groupId, long folderId, Locale locale) throws PortalException {
        return this._provide(groupId, folderId, "", this._getDefaultTitle(locale));
    }

    @Deprecated
    public String provide(long groupId, long folderId, String title) throws PortalException {
        return this._uniqueFileNameProvider.provide(title, generatedTitle -> this._titleExists(groupId, folderId, (String)generatedTitle));
    }

    public String provide(long groupId, long folderId, String extension, Locale locale) throws PortalException {
        return this._provide(groupId, folderId, extension, this._getDefaultTitle(locale));
    }

    public String provide(long groupId, long folderId, String extension, String title) throws PortalException {
        return this._provide(groupId, folderId, extension, title);
    }

    private boolean _exists(UnsafeRunnable<PortalException> unsafeRunnable) {
        try {
            unsafeRunnable.run();
            return true;
        }
        catch (NoSuchFileEntryException noSuchFileEntryException) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)noSuchFileEntryException);
            }
        }
        catch (PortalException portalException) {
            throw new SystemException((Throwable)portalException);
        }
        return false;
    }

    private boolean _fileNameExists(long groupId, long folderId, String fileName) {
        return this._exists((UnsafeRunnable<PortalException>)((UnsafeRunnable)() -> this._dlAppLocalService.getFileEntryByFileName(groupId, folderId, fileName)));
    }

    private String _getDefaultTitle(Locale locale) {
        return this._language.get(locale, "untitled");
    }

    private String _provide(long groupId, long folderId, String extension, String title) throws PortalException {
        return this._uniqueFileNameProvider.provide(title, generatedTitle -> this._fileNameExists(groupId, folderId, generatedTitle.concat(extension)) || this._titleExists(groupId, folderId, (String)generatedTitle));
    }

    private boolean _titleExists(long groupId, long folderId, String title) {
        return this._exists((UnsafeRunnable<PortalException>)((UnsafeRunnable)() -> this._dlAppLocalService.getFileEntry(groupId, folderId, title)));
    }
}

