/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.opener.model.impl;

import com.liferay.document.library.opener.model.DLOpenerFileEntryReference;
import com.liferay.document.library.opener.service.DLOpenerFileEntryReferenceLocalServiceUtil;

/**
 * The extended model base implementation for the DLOpenerFileEntryReference service. Represents a row in the &quot;DLOpenerFileEntryReference&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DLOpenerFileEntryReferenceImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DLOpenerFileEntryReferenceImpl
 * @see DLOpenerFileEntryReference
 * @generated
 */
public abstract class DLOpenerFileEntryReferenceBaseImpl
	extends DLOpenerFileEntryReferenceModelImpl
	implements DLOpenerFileEntryReference {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a dl opener file entry reference model instance should use the <code>DLOpenerFileEntryReference</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DLOpenerFileEntryReferenceLocalServiceUtil.
				addDLOpenerFileEntryReference(this);
		}
		else {
			DLOpenerFileEntryReferenceLocalServiceUtil.
				updateDLOpenerFileEntryReference(this);
		}
	}

}