/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.opener.internal.upload;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.opener.upload.UniqueFileEntryTitleProvider;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.upload.UniqueFileNameProvider;

import java.util.Locale;
import java.util.ResourceBundle;

import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

/**
 * @author Adolfo Pérez
 */
@Component(service = UniqueFileEntryTitleProvider.class)
public class UniqueFileEntryTitleProviderImpl
	implements UniqueFileEntryTitleProvider {

	@Override
	public String provide(long groupId, long folderId, Locale locale)
		throws PortalException {

		ResourceBundle resourceBundle = ResourceBundleUtil.getBundle(
			locale, UniqueFileEntryTitleProviderImpl.class);

		return _provide(
			groupId, folderId, _language.get(resourceBundle, "untitled"));
	}

	@Override
	public String provide(long groupId, long folderId, String fileName)
		throws PortalException {

		return _provide(groupId, folderId, fileName);
	}

	private boolean _exists(long groupId, long folderId, String fileName) {
		try {
			_dlAppLocalService.getFileEntry(groupId, folderId, fileName);

			return true;
		}
		catch (NoSuchFileEntryException noSuchFileEntryException) {
			if (_log.isDebugEnabled()) {
				_log.debug(noSuchFileEntryException, noSuchFileEntryException);
			}
		}
		catch (PortalException portalException) {
			throw new SystemException(portalException);
		}

		return false;
	}

	private String _provide(long groupId, long folderId, String fileName)
		throws PortalException {

		return _uniqueFileNameProvider.provide(
			fileName,
			generatedFileName -> _exists(groupId, folderId, generatedFileName));
	}

	private static final Log _log = LogFactoryUtil.getLog(
		UniqueFileEntryTitleProviderImpl.class);

	@Reference
	private DLAppLocalService _dlAppLocalService;

	@Reference
	private Language _language;

	@Reference
	private UniqueFileNameProvider _uniqueFileNameProvider;

}