/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.file.rank.service.impl;

import com.liferay.document.library.file.rank.internal.configuration.DLFileRankServiceConfiguration;
import com.liferay.document.library.file.rank.model.DLFileRank;
import com.liferay.document.library.file.rank.service.base.DLFileRankLocalServiceBaseImpl;
import com.liferay.document.library.file.rank.util.comparator.FileRankCreateDateComparator;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.configuration.metatype.bnd.util.ConfigurableUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.util.List;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Modified;

@Component(configurationPid={"com.liferay.document.library.file.rank.internal.configuration.DLFileRankServiceConfiguration"}, property={"model.class.name=com.liferay.document.library.file.rank.model.DLFileRank"}, service={AopService.class})
public class DLFileRankLocalServiceImpl
extends DLFileRankLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DLFileRankLocalServiceImpl.class);
    private volatile DLFileRankServiceConfiguration _dlFileRankServiceConfiguration;

    public DLFileRank addFileRank(long groupId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        DLFileRank dlFileRank;
        block3: {
            long fileRankId = this.counterLocalService.increment();
            dlFileRank = this.dlFileRankPersistence.create(fileRankId);
            dlFileRank.setGroupId(groupId);
            dlFileRank.setCompanyId(companyId);
            dlFileRank.setUserId(userId);
            dlFileRank.setCreateDate(serviceContext.getCreateDate(null));
            dlFileRank.setFileEntryId(fileEntryId);
            dlFileRank.setActive(true);
            try {
                dlFileRank = (DLFileRank)this.dlFileRankPersistence.update((BaseModel)dlFileRank);
            }
            catch (SystemException systemException) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Add failed, fetch {companyId=", companyId, ", userId=", userId, ", fileEntryId=", fileEntryId, "}"}));
                }
                if ((dlFileRank = this.dlFileRankPersistence.fetchByC_U_F(companyId, userId, fileEntryId, false)) != null) break block3;
                throw systemException;
            }
        }
        return dlFileRank;
    }

    public void checkFileRanks() {
        int maxSize = this._dlFileRankServiceConfiguration.maxSize();
        List staleFileRanks = this.dlFileRankFinder.findByStaleRanks(maxSize);
        for (Object[] staleFileRank : staleFileRanks) {
            long groupId = (Long)staleFileRank[0];
            long userId = (Long)staleFileRank[1];
            List dlFileRanks = this.dlFileRankPersistence.findByG_U_A(groupId, userId, true, maxSize, -1, (OrderByComparator)new FileRankCreateDateComparator());
            for (DLFileRank dlFileRank : dlFileRanks) {
                long fileRankId = dlFileRank.getFileRankId();
                try {
                    this.dlFileRankPersistence.remove((BaseModel)dlFileRank);
                }
                catch (Exception exception) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)("Unable to remove file rank " + fileRankId));
                }
            }
        }
    }

    @SystemEvent(type=1)
    public void deleteFileRank(DLFileRank dlFileRank) {
        this.dlFileRankPersistence.remove((BaseModel)dlFileRank);
    }

    public void deleteFileRank(long fileRankId) throws PortalException {
        DLFileRank dlFileRank = this.dlFileRankPersistence.findByPrimaryKey(fileRankId);
        this.dlFileRankLocalService.deleteFileRank(dlFileRank);
    }

    public void deleteFileRanksByFileEntryId(long fileEntryId) {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            this.dlFileRankLocalService.deleteFileRank(dlFileRank);
        }
    }

    public void deleteFileRanksByUserId(long userId) {
        List dlFileRanks = this.dlFileRankPersistence.findByUserId(userId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            this.dlFileRankLocalService.deleteFileRank(dlFileRank);
        }
    }

    public void disableFileRanks(long fileEntryId) {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            dlFileRank.setActive(false);
            this.dlFileRankPersistence.update((BaseModel)dlFileRank);
        }
    }

    public void disableFileRanksByFolderId(long folderId) throws PortalException {
        this.updateFileRanks(this.dlFolderLocalService.getDLFolder(folderId), false);
    }

    public void enableFileRanks(long fileEntryId) {
        List dlFileRanks = this.dlFileRankPersistence.findByFileEntryId(fileEntryId);
        for (DLFileRank dlFileRank : dlFileRanks) {
            dlFileRank.setActive(true);
            this.dlFileRankPersistence.update((BaseModel)dlFileRank);
        }
    }

    public void enableFileRanksByFolderId(long folderId) throws PortalException {
        this.updateFileRanks(this.dlFolderLocalService.getDLFolder(folderId), true);
    }

    public List<DLFileRank> getFileRanks(long groupId, long userId) {
        int maxSize = this._dlFileRankServiceConfiguration.maxSize();
        return this.dlFileRankPersistence.findByG_U_A(groupId, userId, true, 0, maxSize, (OrderByComparator)new FileRankCreateDateComparator());
    }

    public DLFileRank updateFileRank(long groupId, long companyId, long userId, long fileEntryId, ServiceContext serviceContext) {
        DLFileRank dlFileRank = this.dlFileRankPersistence.fetchByC_U_F(companyId, userId, fileEntryId);
        if (dlFileRank != null) {
            dlFileRank.setCreateDate(serviceContext.getCreateDate(null));
            try {
                dlFileRank = (DLFileRank)this.dlFileRankPersistence.update((BaseModel)dlFileRank);
            }
            catch (Exception exception) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Update failed, fetch {companyId=", companyId, ", userId=", userId, ", fileEntryId=", fileEntryId, "}"}));
                }
            }
        } else {
            dlFileRank = this.addFileRank(groupId, companyId, userId, fileEntryId, serviceContext);
        }
        return dlFileRank;
    }

    @Activate
    @Modified
    protected void activate(Map<String, Object> properties) {
        this._dlFileRankServiceConfiguration = (DLFileRankServiceConfiguration)ConfigurableUtil.createConfigurable(DLFileRankServiceConfiguration.class, properties);
    }

    protected void updateFileRanks(DLFolder dlFolder, boolean active) {
        List dlFolders = this.dlFolderLocalService.getFolders(dlFolder.getGroupId(), dlFolder.getFolderId());
        for (DLFolder curDLFolder : dlFolders) {
            this.updateFileRanks(curDLFolder, active);
        }
        List dlFileRanks = this.dlFileRankFinder.findByFolderId(dlFolder.getFolderId());
        for (DLFileRank dlFileRank : dlFileRanks) {
            dlFileRank.setActive(active);
            this.dlFileRankPersistence.update((BaseModel)dlFileRank);
        }
    }
}

