/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.signatures;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.net.URI;
import java.security.SignatureException;
import net.oauth.jsontoken.Checker;

public class SignedJsonAssertionAudienceChecker
implements Checker {
    private final String tokenEndpointUri;

    public SignedJsonAssertionAudienceChecker(String uri) {
        this.tokenEndpointUri = uri;
    }

    @Override
    public void check(JsonObject payload) throws SignatureException {
        SignedJsonAssertionAudienceChecker.checkUri(this.tokenEndpointUri, Preconditions.checkNotNull(payload.get("aud").getAsString(), "Audience cannot be null!"));
    }

    private static void checkUri(String ourUriString, String tokenUriString) throws SignatureException {
        URI ourUri = URI.create(ourUriString);
        URI tokenUri = URI.create(tokenUriString);
        if (!ourUri.getScheme().equalsIgnoreCase(tokenUri.getScheme())) {
            throw new SignatureException("scheme in token URI (" + tokenUri.getScheme() + ") is wrong");
        }
        if (!ourUri.getAuthority().equalsIgnoreCase(tokenUri.getAuthority())) {
            throw new SignatureException("authority in token URI (" + tokenUri.getAuthority() + ") is wrong");
        }
    }
}

