/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.document.conversion.internal;

import com.google.common.collect.Lists;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.security.SecureRandomUtil;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import java.util.Date;
import java.util.List;
import net.oauth.jsontoken.Checker;
import net.oauth.jsontoken.JsonToken;
import net.oauth.jsontoken.JsonTokenParser;
import net.oauth.jsontoken.crypto.HmacSHA256Signer;
import net.oauth.jsontoken.crypto.HmacSHA256Verifier;
import net.oauth.jsontoken.crypto.SignatureAlgorithm;
import net.oauth.jsontoken.crypto.Verifier;
import net.oauth.jsontoken.discovery.VerifierProvider;
import net.oauth.jsontoken.discovery.VerifierProviders;
import org.joda.time.Instant;

public class ImageRequestTokenUtil {
    private static final long _EXPIRATION = 600000L;
    private static final byte[] _SECRET;
    private static final Log _log;

    public static String createToken(long userId) {
        HmacSHA256Signer signer = null;
        try {
            signer = new HmacSHA256Signer(null, null, _SECRET);
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to create signer", (Throwable)exception);
            }
            return null;
        }
        JsonToken jsonToken = new JsonToken(signer);
        Instant instant = new Instant();
        jsonToken.setExpiration(instant.plus(600000L));
        jsonToken.setIssuedAt(instant);
        JsonObject payloadJsonObject = jsonToken.getPayloadAsJsonObject();
        payloadJsonObject.addProperty("userId", (Number)userId);
        try {
            return jsonToken.serializeAndSign();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)"Unable to sign payload", (Throwable)exception);
            }
            return null;
        }
    }

    public static long getUserId(String tokenString) {
        try {
            Instant instant;
            JsonTokenParser jsonTokenParser = ImageRequestTokenUtil._getJsonTokenParser();
            JsonToken jsonToken = jsonTokenParser.verifyAndDeserialize(tokenString);
            JsonPrimitive userIdJsonPrimitive = jsonToken.getParamAsPrimitive("userId");
            if (userIdJsonPrimitive == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Unable to find \"userId\" parameter in payload " + tokenString));
                }
                return 0L;
            }
            long userId = userIdJsonPrimitive.getAsLong();
            User user = UserLocalServiceUtil.fetchUser((long)userId);
            Date passwordModifiedDate = user.getPasswordModifiedDate();
            if (passwordModifiedDate != null && (instant = jsonToken.getIssuedAt()).isBefore(passwordModifiedDate.getTime())) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)"Unable to accept token because the password was changed");
                }
                return 0L;
            }
            return userId;
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Unable to parse and verify token " + tokenString), (Throwable)exception);
            }
            return 0L;
        }
    }

    private static JsonTokenParser _getJsonTokenParser() throws Exception {
        final HmacSHA256Verifier verifier = new HmacSHA256Verifier(_SECRET);
        VerifierProvider verifierProvider = new VerifierProvider(){

            @Override
            public List<Verifier> findVerifier(String signerId, String keyId) {
                return Lists.newArrayList(verifier);
            }
        };
        VerifierProviders verifyProviders = new VerifierProviders();
        verifyProviders.setVerifierProvider(SignatureAlgorithm.HS256, verifierProvider);
        Checker checker = new Checker(){

            @Override
            public void check(JsonObject jsonObject) {
            }
        };
        return new JsonTokenParser(verifyProviders, checker);
    }

    static {
        _log = LogFactoryUtil.getLog(ImageRequestTokenUtil.class);
        int sha256BlockSize = 64;
        byte[] secret = new byte[sha256BlockSize];
        for (int i = 0; i < secret.length; ++i) {
            secret[i] = SecureRandomUtil.nextByte();
        }
        _SECRET = secret;
    }
}

