/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */

package com.liferay.document.library.document.conversion.internal.upgrade.v1_0_0;

import com.liferay.document.library.document.conversion.internal.configuration.OpenOfficeConfiguration;
import com.liferay.document.library.document.conversion.internal.constants.LegacyOpenOfficePropsKeys;
import com.liferay.portal.configuration.upgrade.PrefsPropsToConfigurationUpgradeHelper;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.KeyValuePair;

/**
 * @author Pei-Jung Lan
 */
public class OpenOfficeConfigurationUpgradeProcess extends UpgradeProcess {

	public OpenOfficeConfigurationUpgradeProcess(
		PrefsPropsToConfigurationUpgradeHelper
			prefsPropsToConfigurationUpgradeHelper) {

		_prefsPropsToConfigurationUpgradeHelper =
			prefsPropsToConfigurationUpgradeHelper;
	}

	@Override
	protected void doUpgrade() throws Exception {
		_prefsPropsToConfigurationUpgradeHelper.mapConfigurations(
			OpenOfficeConfiguration.class,
			new KeyValuePair(
				LegacyOpenOfficePropsKeys.OPENOFFICE_CACHE_ENABLED,
				"cacheEnabled"),
			new KeyValuePair(
				LegacyOpenOfficePropsKeys.OPENOFFICE_SERVER_ENABLED,
				"serverEnabled"),
			new KeyValuePair(
				LegacyOpenOfficePropsKeys.OPENOFFICE_SERVER_HOST, "serverHost"),
			new KeyValuePair(
				LegacyOpenOfficePropsKeys.OPENOFFICE_SERVER_PORT,
				"serverPort"));
	}

	private final PrefsPropsToConfigurationUpgradeHelper
		_prefsPropsToConfigurationUpgradeHelper;

}