/**
 * SPDX-FileCopyrightText: (c) 2000 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.document.library.content.model.impl;

import com.liferay.document.library.content.model.DLContent;
import com.liferay.portal.kernel.model.CacheModel;
import com.liferay.portal.kernel.util.HashUtil;
import com.liferay.portal.kernel.util.StringBundler;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

/**
 * The cache model class for representing DLContent in entity cache.
 *
 * @author Brian Wing Shun Chan
 * @generated
 */
public class DLContentCacheModel
	implements CacheModel<DLContent>, Externalizable {

	@Override
	public boolean equals(Object object) {
		if (this == object) {
			return true;
		}

		if (!(object instanceof DLContentCacheModel)) {
			return false;
		}

		DLContentCacheModel dlContentCacheModel = (DLContentCacheModel)object;

		if (contentId == dlContentCacheModel.contentId) {
			return true;
		}

		return false;
	}

	@Override
	public int hashCode() {
		return HashUtil.hash(0, contentId);
	}

	@Override
	public String toString() {
		StringBundler sb = new StringBundler(15);

		sb.append("{contentId=");
		sb.append(contentId);
		sb.append(", groupId=");
		sb.append(groupId);
		sb.append(", companyId=");
		sb.append(companyId);
		sb.append(", repositoryId=");
		sb.append(repositoryId);
		sb.append(", path=");
		sb.append(path);
		sb.append(", version=");
		sb.append(version);
		sb.append(", size=");
		sb.append(size);
		sb.append("}");

		return sb.toString();
	}

	@Override
	public DLContent toEntityModel() {
		DLContentImpl dlContentImpl = new DLContentImpl();

		dlContentImpl.setContentId(contentId);
		dlContentImpl.setGroupId(groupId);
		dlContentImpl.setCompanyId(companyId);
		dlContentImpl.setRepositoryId(repositoryId);

		if (path == null) {
			dlContentImpl.setPath("");
		}
		else {
			dlContentImpl.setPath(path);
		}

		if (version == null) {
			dlContentImpl.setVersion("");
		}
		else {
			dlContentImpl.setVersion(version);
		}

		dlContentImpl.setSize(size);

		dlContentImpl.resetOriginalValues();

		return dlContentImpl;
	}

	@Override
	public void readExternal(ObjectInput objectInput) throws IOException {
		contentId = objectInput.readLong();

		groupId = objectInput.readLong();

		companyId = objectInput.readLong();

		repositoryId = objectInput.readLong();
		path = objectInput.readUTF();
		version = objectInput.readUTF();

		size = objectInput.readLong();
	}

	@Override
	public void writeExternal(ObjectOutput objectOutput) throws IOException {
		objectOutput.writeLong(contentId);

		objectOutput.writeLong(groupId);

		objectOutput.writeLong(companyId);

		objectOutput.writeLong(repositoryId);

		if (path == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(path);
		}

		if (version == null) {
			objectOutput.writeUTF("");
		}
		else {
			objectOutput.writeUTF(version);
		}

		objectOutput.writeLong(size);
	}

	public long contentId;
	public long groupId;
	public long companyId;
	public long repositoryId;
	public String path;
	public String version;
	public long size;

}