<%--
/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * The contents of this file are subject to the terms of the Liferay Enterprise
 * Subscription License ("License"). You may not use this file except in
 * compliance with the License. You can obtain a copy of the License by
 * contacting Liferay, Inc. See the License for the specific language governing
 * permissions and limitations under the License, including but not limited to
 * distribution rights of the Software.
 *
 *
 *
 */
--%>

<%@ include file="/dynamic_include/init.jsp" %>

<script data-senna-track="temporary" type="text/javascript">
	if (window.Analytics) {
		window.<%= DocumentLibraryAnalyticsConstants.JS_PREFIX %>isViewFileEntry = false;
	}
</script>

<aui:script sandbox="<%= true %>">
	var pathnameRegexp = /\/documents\/(\d+)\/(\d+)\/(.+?)\/([^&]+)/;

	function handleDownloadClick(event) {
		if (event.target.nodeName.toLowerCase() === 'a' && window.Analytics) {
			var anchor = event.target;
			var match = pathnameRegexp.exec(anchor.pathname);

			var fileEntryId =
				anchor.dataset.analyticsFileEntryId ||
				(anchor.parentElement &&
					anchor.parentElement.dataset.analyticsFileEntryId);

			if (fileEntryId && match) {
				var getParameterValue = function (parameterName) {
					var result = null;

					anchor.search
						.substr(1)
						.split('&')
						.forEach((item) => {
							var tmp = item.split('=');

							if (tmp[0] === parameterName) {
								result = decodeURIComponent(tmp[1]);
							}
						});

					return result;
				};

				Analytics.send('documentDownloaded', 'Document', {
					groupId: match[1],
					fileEntryId: fileEntryId,
					preview: !!window.<%= DocumentLibraryAnalyticsConstants.JS_PREFIX %>isViewFileEntry,
					title: decodeURIComponent(match[3].replace(/\+/gi, ' ')),
					version: getParameterValue('version'),
				});
			}
		}
	}

	Liferay.once('destroyPortlet', () => {
		document.body.removeEventListener('click', handleDownloadClick);
	});

	Liferay.once('portletReady', () => {
		document.body.addEventListener('click', handleDownloadClick);
	});
</aui:script>