/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.helper;

import com.liferay.dispatch.exception.DispatchTriggerSchedulerException;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.scheduler.messaging.SchedulerResponse;
import java.util.Date;
import java.util.TimeZone;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DispatchTriggerHelper.class})
public class DispatchTriggerHelper {
    private static final Log _log = LogFactoryUtil.getLog(DispatchTriggerHelper.class);
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    public void addSchedulerJob(DispatchTrigger dispatchTrigger, StorageType storageType, String timeZoneId) throws DispatchTriggerSchedulerException {
        Date date = new Date();
        Date endDate = dispatchTrigger.getEndDate();
        Date startDate = dispatchTrigger.getStartDate();
        if (startDate != null && startDate.before(date) && (endDate == null || startDate.before(endDate) && endDate.after(date))) {
            startDate = date;
        }
        Trigger trigger = this._triggerFactory.createTrigger(this._getJobName(dispatchTrigger), this._getGroupName(dispatchTrigger), startDate, endDate, dispatchTrigger.getCronExpression(), TimeZone.getTimeZone(timeZoneId));
        Message message = new Message();
        message.put("companyId", (Object)dispatchTrigger.getCompanyId());
        message.setPayload((Object)this._getPayload(dispatchTrigger.getDispatchTriggerId()));
        try {
            this._schedulerEngineHelper.schedule(trigger, storageType, null, "liferay/dispatch/executor", message);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Scheduler entry created for dispatch trigger " + dispatchTrigger.getDispatchTriggerId()));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new DispatchTriggerSchedulerException("Unable to create scheduler entry for dispatch trigger " + dispatchTrigger.getDispatchTriggerId(), (Throwable)schedulerException);
        }
    }

    public void deleteSchedulerJob(DispatchTrigger dispatchTrigger, StorageType storageType) {
        try {
            String jobName = this._getJobName(dispatchTrigger);
            String groupName = this._getGroupName(dispatchTrigger);
            this._schedulerEngineHelper.delete(jobName, groupName, storageType);
            SchedulerResponse scheduledJob = this._schedulerEngineHelper.getScheduledJob(jobName, groupName, storageType);
            while (scheduledJob != null) {
                scheduledJob = this._schedulerEngineHelper.getScheduledJob(jobName, groupName, storageType);
            }
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)("Unable to delete scheduler entry for dispatch trigger " + dispatchTrigger.getDispatchTriggerId()), (Throwable)schedulerException);
        }
    }

    public Date getNextFireDate(DispatchTrigger dispatchTrigger, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(this._getJobName(dispatchTrigger), this._getGroupName(dispatchTrigger), storageType);
        if (schedulerResponse == null) {
            return null;
        }
        return this._schedulerEngineHelper.getNextFireTime(schedulerResponse);
    }

    public Date getPreviousFireDate(DispatchTrigger dispatchTrigger, StorageType storageType) throws SchedulerException {
        SchedulerResponse schedulerResponse = this._schedulerEngineHelper.getScheduledJob(this._getJobName(dispatchTrigger), this._getGroupName(dispatchTrigger), storageType);
        if (schedulerResponse == null) {
            return null;
        }
        return this._schedulerEngineHelper.getPreviousFireTime(schedulerResponse);
    }

    private String _getGroupName(DispatchTrigger dispatchTrigger) {
        return StringBundler.concat((Object[])new Object[]{"DISPATCH_GROUP_", String.format("%07d", dispatchTrigger.getDispatchTriggerId()), "@", dispatchTrigger.getCompanyId()});
    }

    private String _getJobName(DispatchTrigger dispatchTrigger) {
        return StringBundler.concat((Object[])new Object[]{"DISPATCH_JOB_", String.format("%07d", dispatchTrigger.getDispatchTriggerId()), "@", dispatchTrigger.getCompanyId()});
    }

    private String _getPayload(long dispatchTriggerId) {
        return StringBundler.concat((Object[])new Object[]{"{\"dispatchTriggerId\": ", dispatchTriggerId, "}"});
    }
}

