/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.messaging;

import com.liferay.dispatch.exception.DispatchTriggerSchedulerException;
import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.internal.helper.DispatchTriggerHelper;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.portal.kernel.cluster.ClusterMasterExecutor;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.messaging.Destination;
import com.liferay.portal.kernel.messaging.DestinationConfiguration;
import com.liferay.portal.kernel.messaging.DestinationFactory;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.HashMapDictionaryBuilder;
import java.util.Dictionary;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={})
public class DispatchConfigurator {
    private static final int _MAXIMUM_QUEUE_SIZE = 100;
    private static final Log _log = LogFactoryUtil.getLog(DispatchConfigurator.class);
    @Reference
    private ClusterMasterExecutor _clusterMasterExecutor;
    @Reference
    private DestinationFactory _destinationFactory;
    @Reference
    private DispatchTriggerHelper _dispatchTriggerHelper;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    private ServiceRegistration<Destination> _serviceRegistration;

    @Activate
    protected void activate(BundleContext bundleContext) {
        DestinationConfiguration destinationConfiguration = new DestinationConfiguration("parallel", "liferay/dispatch/executor");
        destinationConfiguration.setMaximumQueueSize(100);
        ThreadPoolExecutor.CallerRunsPolicy rejectedExecutionHandler = new ThreadPoolExecutor.CallerRunsPolicy(){

            @Override
            public void rejectedExecution(Runnable runnable, ThreadPoolExecutor threadPoolExecutor) {
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)"The current thread will handle the request because the graph walker's task queue is at its maximum capacity");
                }
                super.rejectedExecution(runnable, threadPoolExecutor);
            }
        };
        destinationConfiguration.setRejectedExecutionHandler((RejectedExecutionHandler)rejectedExecutionHandler);
        Destination destination = this._destinationFactory.createDestination(destinationConfiguration);
        HashMapDictionary properties = HashMapDictionaryBuilder.put((Object)"destination.name", (Object)destination.getName()).build();
        this._serviceRegistration = bundleContext.registerService(Destination.class, (Object)destination, (Dictionary)properties);
        for (DispatchTrigger dispatchTrigger : this._dispatchTriggerLocalService.getDispatchTriggers(true)) {
            DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getDispatchTaskClusterMode());
            if (!this._isSchedulable(dispatchTaskClusterMode)) continue;
            try {
                this._dispatchTriggerHelper.addSchedulerJob(dispatchTrigger, dispatchTaskClusterMode.getStorageType(), dispatchTrigger.getTimeZoneId());
            }
            catch (DispatchTriggerSchedulerException dispatchTriggerSchedulerException) {
                _log.error((Throwable)dispatchTriggerSchedulerException);
            }
        }
    }

    @Deactivate
    protected void deactivate() {
        for (DispatchTrigger dispatchTrigger : this._dispatchTriggerLocalService.getDispatchTriggers(true)) {
            DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getDispatchTaskClusterMode());
            if (!this._isSchedulable(dispatchTaskClusterMode)) continue;
            this._dispatchTriggerHelper.deleteSchedulerJob(dispatchTrigger, dispatchTaskClusterMode.getStorageType());
        }
        this._serviceRegistration.unregister();
    }

    private boolean _isSchedulable(DispatchTaskClusterMode dispatchTaskClusterMode) {
        return dispatchTaskClusterMode == DispatchTaskClusterMode.ALL_NODES || this._clusterMasterExecutor.isMaster() && (dispatchTaskClusterMode == DispatchTaskClusterMode.SINGLE_NODE_MEMORY_CLUSTERED || dispatchTaskClusterMode == DispatchTaskClusterMode.SINGLE_NODE_PERSISTED);
    }
}

