/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.exception.DispatchTriggerEndDateException;
import com.liferay.dispatch.exception.DispatchTriggerNameException;
import com.liferay.dispatch.exception.DispatchTriggerStartDateException;
import com.liferay.dispatch.exception.DuplicateDispatchTriggerException;
import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.internal.helper.DispatchTriggerHelper;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchTriggerLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PortalRunMode;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dispatch.model.DispatchTrigger"}, service={AopService.class})
public class DispatchTriggerLocalServiceImpl
extends DispatchTriggerLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DispatchTriggerLocalServiceImpl.class);
    @Reference
    private DispatchTriggerHelper _dispatchTriggerHelper;
    @Reference
    private Portal _portal;

    public DispatchTrigger addDispatchTrigger(long userId, String dispatchTaskExecutorType, UnicodeProperties dispatchTaskSettingsUnicodeProperties, String name, boolean system) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(0L, user.getCompanyId(), name);
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.create(this.counterLocalService.increment());
        dispatchTrigger.setCompanyId(user.getCompanyId());
        dispatchTrigger.setUserId(user.getUserId());
        dispatchTrigger.setUserName(user.getFullName());
        dispatchTrigger.setDispatchTaskExecutorType(dispatchTaskExecutorType);
        dispatchTrigger.setDispatchTaskSettingsUnicodeProperties(dispatchTaskSettingsUnicodeProperties);
        dispatchTrigger.setName(name);
        dispatchTrigger.setSystem(system);
        dispatchTrigger = (DispatchTrigger)this.dispatchTriggerPersistence.update((BaseModel)dispatchTrigger);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), DispatchTrigger.class.getName(), dispatchTrigger.getDispatchTriggerId(), false, true, true);
        return dispatchTrigger;
    }

    @Override
    @SystemEvent(type=1)
    public DispatchTrigger deleteDispatchTrigger(DispatchTrigger dispatchTrigger) throws PortalException {
        if (dispatchTrigger.isSystem() && !PortalRunMode.isTestMode()) {
            return dispatchTrigger;
        }
        this.dispatchLogPersistence.removeByDispatchTriggerId(dispatchTrigger.getDispatchTriggerId());
        this.dispatchTriggerPersistence.remove((BaseModel)dispatchTrigger);
        this.resourceLocalService.deleteResource((AuditedModel)dispatchTrigger, 4);
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getDispatchTaskClusterMode());
        this._dispatchTriggerHelper.deleteSchedulerJob(dispatchTrigger.getDispatchTriggerId(), dispatchTaskClusterMode.getStorageType());
        return dispatchTrigger;
    }

    @Override
    public DispatchTrigger deleteDispatchTrigger(long dispatchTriggerId) throws PortalException {
        return this.deleteDispatchTrigger(this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId));
    }

    public DispatchTrigger fetchDispatchTrigger(long companyId, String name) {
        return this.dispatchTriggerPersistence.fetchByC_N(companyId, name);
    }

    public Date fetchNextFireDate(long dispatchTriggerId) {
        try {
            return this.getNextFireDate(dispatchTriggerId);
        }
        catch (PortalException portalException) {
            _log.error((Object)("Unable to resolve next fire date for dispatch trigger ID " + dispatchTriggerId), (Throwable)portalException);
            return null;
        }
    }

    public Date fetchPreviousFireDate(long dispatchTriggerId) {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.fetchByPrimaryKey(dispatchTriggerId);
        if (dispatchTrigger == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to fetch dispatch trigger ID " + dispatchTriggerId));
            }
            return null;
        }
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getDispatchTaskClusterMode());
        try {
            return this._dispatchTriggerHelper.getPreviousFireDate(dispatchTriggerId, dispatchTaskClusterMode.getStorageType());
        }
        catch (SchedulerException schedulerException) {
            if (_log.isWarnEnabled()) {
                StringBundler sb = new StringBundler(3);
                sb.append("Unable to fetch previous fire date for dispatch ");
                sb.append("trigger ID ");
                sb.append(dispatchTriggerId);
                _log.warn((Object)sb.toString(), (Throwable)schedulerException);
            }
            return null;
        }
    }

    @Override
    public DispatchTrigger getDispatchTrigger(long dispatchTriggerId) throws PortalException {
        return this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
    }

    public List<DispatchTrigger> getDispatchTriggers(boolean active, DispatchTaskClusterMode dispatchTaskClusterMode) {
        return this.dispatchTriggerPersistence.findByA_DTCM(active, dispatchTaskClusterMode.getMode());
    }

    public List<DispatchTrigger> getDispatchTriggers(long companyId, int start, int end) {
        return this.dispatchTriggerPersistence.findByCompanyId(companyId, start, end);
    }

    public int getDispatchTriggersCount(long companyId) {
        return this.dispatchTriggerPersistence.countByCompanyId(companyId);
    }

    public Date getNextFireDate(long dispatchTriggerId) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getDispatchTaskClusterMode());
        return this._dispatchTriggerHelper.getNextFireDate(dispatchTriggerId, dispatchTaskClusterMode.getStorageType());
    }

    public Date getPreviousFireDate(long dispatchTriggerId) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getDispatchTaskClusterMode());
        return this._dispatchTriggerHelper.getPreviousFireDate(dispatchTriggerId, dispatchTaskClusterMode.getStorageType());
    }

    public List<DispatchTrigger> getUserDispatchTriggers(long companyId, long userId, int start, int end) {
        return this.dispatchTriggerPersistence.findByC_U(companyId, userId, start, end);
    }

    public int getUserDispatchTriggersCount(long companyId, long userId) {
        return this.dispatchTriggerPersistence.countByC_U(companyId, userId);
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, boolean active, String cronExpression, DispatchTaskClusterMode dispatchTaskClusterMode, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverEnd, boolean overlapAllowed, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.fetchByPrimaryKey(dispatchTriggerId);
        dispatchTrigger.setActive(active);
        dispatchTrigger.setCronExpression(cronExpression);
        if (neverEnd) {
            dispatchTrigger.setEndDate(null);
        } else {
            dispatchTrigger.setEndDate(this._portal.getDate(endDateMonth, endDateDay, endDateYear, endDateHour, endDateMinute, DispatchTriggerEndDateException.class));
        }
        dispatchTrigger.setOverlapAllowed(overlapAllowed);
        dispatchTrigger.setStartDate(this._portal.getDate(startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, DispatchTriggerStartDateException.class));
        dispatchTrigger.setDispatchTaskClusterMode(dispatchTaskClusterMode.getMode());
        dispatchTrigger = (DispatchTrigger)this.dispatchTriggerPersistence.update((BaseModel)dispatchTrigger);
        this._dispatchTriggerHelper.deleteSchedulerJob(dispatchTriggerId, dispatchTaskClusterMode.getStorageType());
        if (active) {
            this._dispatchTriggerHelper.addSchedulerJob(dispatchTriggerId, cronExpression, dispatchTrigger.getStartDate(), dispatchTrigger.getEndDate(), dispatchTaskClusterMode.getStorageType());
        }
        return dispatchTrigger;
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, UnicodeProperties taskSettingsUnicodeProperties, String name) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        this.validate(dispatchTriggerId, dispatchTrigger.getCompanyId(), name);
        dispatchTrigger.setName(name);
        dispatchTrigger.setDispatchTaskSettingsUnicodeProperties(taskSettingsUnicodeProperties);
        return (DispatchTrigger)this.dispatchTriggerPersistence.update((BaseModel)dispatchTrigger);
    }

    protected void validate(long dispatchTriggerId, long companyId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new DispatchTriggerNameException("Dispatch trigger name is null for company " + companyId);
        }
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.fetchByC_N(companyId, name);
        if (dispatchTrigger == null) {
            return;
        }
        if (dispatchTriggerId > 0L && dispatchTrigger.getDispatchTriggerId() == dispatchTriggerId) {
            return;
        }
        throw new DuplicateDispatchTriggerException(StringBundler.concat((Object[])new Object[]{"Dispatch trigger name \"", name, "\" already exists for company ", companyId}));
    }
}

