/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchTriggerServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"json.web.service.context.name=dispatch", "json.web.service.context.path=DispatchTrigger"}, service={AopService.class})
public class DispatchTriggerServiceImpl
extends DispatchTriggerServiceBaseImpl {
    private static volatile ModelResourcePermission<DispatchTrigger> _dispatchTriggerModelResourcePermission = ModelResourcePermissionFactory.getInstance(DispatchTriggerServiceImpl.class, (String)"_dispatchTriggerModelResourcePermission", DispatchTrigger.class);
    @Reference(target="(resource.name=com.liferay.dispatch)")
    private PortletResourcePermission _portletResourcePermission;

    public DispatchTrigger addDispatchTrigger(String externalReferenceCode, long userId, String dispatchTaskExecutorType, UnicodeProperties dispatchTaskSettingsUnicodeProperties, String name) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), 0L, "ADD_DISPATCH_TRIGGER");
        return this.dispatchTriggerLocalService.addDispatchTrigger(externalReferenceCode, userId, dispatchTaskExecutorType, dispatchTaskSettingsUnicodeProperties, name, false);
    }

    public void deleteDispatchTrigger(long dispatchTriggerId) throws PortalException {
        _dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "DELETE");
        this.dispatchTriggerLocalService.deleteDispatchTrigger(dispatchTriggerId);
    }

    public List<DispatchTrigger> getDispatchTriggers(int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.dispatchTriggerLocalService.getDispatchTriggers(permissionChecker.getCompanyId(), start, end);
        }
        return this.dispatchTriggerLocalService.getUserDispatchTriggers(permissionChecker.getCompanyId(), permissionChecker.getUserId(), start, end);
    }

    public int getDispatchTriggersCount() throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.dispatchTriggerLocalService.getDispatchTriggersCount(permissionChecker.getCompanyId());
        }
        return this.dispatchTriggerLocalService.getUserDispatchTriggersCount(permissionChecker.getCompanyId(), permissionChecker.getUserId());
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, boolean active, String cronExpression, DispatchTaskClusterMode dispatchTaskClusterMode, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverEnd, boolean overlapAllowed, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, String timeZoneId) throws PortalException {
        _dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "UPDATE");
        return this.dispatchTriggerLocalService.updateDispatchTrigger(dispatchTriggerId, active, cronExpression, dispatchTaskClusterMode, endDateMonth, endDateDay, endDateYear, endDateHour, endDateMinute, neverEnd, overlapAllowed, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, timeZoneId);
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, UnicodeProperties dispatchTaskSettingsUnicodeProperties, String name) throws PortalException {
        _dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "UPDATE");
        return this.dispatchTriggerLocalService.updateDispatchTrigger(dispatchTriggerId, dispatchTaskSettingsUnicodeProperties, name);
    }
}

