/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.metadata;

import com.liferay.dispatch.metadata.DispatchTriggerMetadata;
import com.liferay.dispatch.metadata.DispatchTriggerMetadataFactory;
import com.liferay.dispatch.metadata.DispatchTriggerMetadataProvider;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.util.StringBundler;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(service={DispatchTriggerMetadataProvider.class})
public class DispatchTriggerMetadataProviderImpl
implements DispatchTriggerMetadataProvider {
    private static final String _KEY_DISPATCH_TASK_EXECUTOR_TYPE = "dispatch.task.executor.type";
    private static final Log _log = LogFactoryUtil.getLog(DispatchTriggerMetadataProviderImpl.class);
    private static final DispatchTriggerMetadata _defaultDispatchTriggerMetadata = new DispatchTriggerMetadata(){

        public Map<String, String> getAttributes() {
            return Collections.emptyMap();
        }

        public Map<String, String> getErrors() {
            return Collections.emptyMap();
        }

        public boolean isDispatchTaskExecutorReady() {
            return true;
        }
    };
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    private final Map<String, DispatchTriggerMetadataFactory> _dispatchTriggerMetadataBuilders = new HashMap<String, DispatchTriggerMetadataFactory>();

    public DispatchTriggerMetadata getDispatchTriggerMetadata(long dispatchTriggerId) {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.fetchDispatchTrigger(dispatchTriggerId);
        if (dispatchTrigger == null || !this._dispatchTriggerMetadataBuilders.containsKey(dispatchTrigger.getDispatchTaskExecutorType())) {
            return _defaultDispatchTriggerMetadata;
        }
        DispatchTriggerMetadataFactory dispatchTriggerMetadataFactory = this._dispatchTriggerMetadataBuilders.get(dispatchTrigger.getDispatchTaskExecutorType());
        return dispatchTriggerMetadataFactory.instance(dispatchTrigger);
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDispatchTriggerMetadataBuilder(DispatchTriggerMetadataFactory dispatchTriggerMetadataFactory, Map<String, Object> properties) {
        String dispatchTaskExecutorType = (String)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_TYPE);
        this._validateDispatchTriggerMetadataBuilderProperties(dispatchTriggerMetadataFactory, dispatchTaskExecutorType);
        this._dispatchTriggerMetadataBuilders.put(dispatchTaskExecutorType, dispatchTriggerMetadataFactory);
    }

    protected void removeDispatchTriggerMetadataBuilder(DispatchTriggerMetadataFactory dispatchTriggerMetadataFactory, Map<String, Object> properties) {
        String dispatchTaskExecutorType = (String)properties.get(_KEY_DISPATCH_TASK_EXECUTOR_TYPE);
        this._dispatchTriggerMetadataBuilders.remove(dispatchTaskExecutorType);
    }

    private void _validateDispatchTriggerMetadataBuilderProperties(DispatchTriggerMetadataFactory dispatchTriggerMetadataFactory, String dispatchTaskExecutorType) {
        if (!this._dispatchTriggerMetadataBuilders.containsKey(dispatchTaskExecutorType)) {
            return;
        }
        DispatchTriggerMetadataFactory curDispatchTriggerMetadataFactory = this._dispatchTriggerMetadataBuilders.get(dispatchTaskExecutorType);
        Class<?> clazz1 = curDispatchTriggerMetadataFactory.getClass();
        Class<?> clazz2 = dispatchTriggerMetadataFactory.getClass();
        _log.error((Object)StringBundler.concat((String[])new String[]{_KEY_DISPATCH_TASK_EXECUTOR_TYPE, " property must have unique ", "value. The same value is found in ", clazz1.getName(), " and ", clazz2.getName(), "."}));
    }
}

