/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.security.permission.resource;

import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dispatch.model.DispatchTrigger"}, service={ModelResourcePermission.class})
public class DispatchTriggerModelResourcePermission
implements ModelResourcePermission<DispatchTrigger> {
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;

    public void check(PermissionChecker permissionChecker, DispatchTrigger dispatchTrigger, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, dispatchTrigger, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DispatchTrigger.class.getName(), dispatchTrigger.getDispatchTriggerId(), new String[]{actionId});
        }
    }

    public void check(PermissionChecker permissionChecker, long primaryKey, String actionId) throws PortalException {
        if (!this.contains(permissionChecker, primaryKey, actionId)) {
            throw new PrincipalException.MustHavePermission(permissionChecker, DispatchTrigger.class.getName(), primaryKey, new String[]{actionId});
        }
    }

    public boolean contains(PermissionChecker permissionChecker, DispatchTrigger dispatchTrigger, String actionId) {
        if (permissionChecker.isCompanyAdmin(dispatchTrigger.getCompanyId())) {
            return true;
        }
        return permissionChecker.hasPermission(0L, DispatchTrigger.class.getName(), dispatchTrigger.getDispatchTriggerId(), actionId);
    }

    public boolean contains(PermissionChecker permissionChecker, long dispatchTriggerId, String actionId) throws PortalException {
        return this.contains(permissionChecker, this._dispatchTriggerLocalService.getDispatchTrigger(dispatchTriggerId), actionId);
    }

    public String getModelName() {
        return DispatchTrigger.class.getName();
    }

    public PortletResourcePermission getPortletResourcePermission() {
        return null;
    }
}

