/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchTriggerServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionFactory;
import com.liferay.portal.kernel.service.permission.PortalPermissionUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"json.web.service.context.name=dispatch", "json.web.service.context.path=DispatchTrigger"}, service={AopService.class})
public class DispatchTriggerServiceImpl
extends DispatchTriggerServiceBaseImpl {
    private static volatile ModelResourcePermission<DispatchTrigger> _dispatchTriggerModelResourcePermission = ModelResourcePermissionFactory.getInstance(DispatchTriggerServiceImpl.class, (String)"_dispatchTriggerModelResourcePermission", DispatchTrigger.class);

    public DispatchTrigger addDispatchTrigger(long userId, String name, String taskExecutorType, UnicodeProperties taskSettingsUnicodeProperties) throws PortalException {
        PortalPermissionUtil.check((PermissionChecker)this.getPermissionChecker(), (String)"ADD_DISPATCH_TRIGGER");
        return this.dispatchTriggerLocalService.addDispatchTrigger(userId, name, false, taskExecutorType, taskSettingsUnicodeProperties);
    }

    public void deleteDispatchTrigger(long dispatchTriggerId) throws PortalException {
        _dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "DELETE");
        this.dispatchTriggerLocalService.deleteDispatchTrigger(dispatchTriggerId);
    }

    public List<DispatchTrigger> getDispatchTriggers(int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.dispatchTriggerLocalService.getDispatchTriggers(permissionChecker.getCompanyId(), start, end);
        }
        return this.dispatchTriggerLocalService.getUserDispatchTriggers(permissionChecker.getCompanyId(), permissionChecker.getUserId(), start, end);
    }

    public int getDispatchTriggersCount() throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (permissionChecker.isCompanyAdmin()) {
            return this.dispatchTriggerLocalService.getDispatchTriggersCount(permissionChecker.getCompanyId());
        }
        return this.dispatchTriggerLocalService.getUserDispatchTriggersCount(permissionChecker.getCompanyId(), permissionChecker.getUserId());
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, boolean active, String cronExpression, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverEnd, boolean overlapAllowed, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, DispatchTaskClusterMode dispatchTaskClusterMode) throws PortalException {
        _dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "UPDATE");
        return this.dispatchTriggerLocalService.updateDispatchTrigger(dispatchTriggerId, active, cronExpression, endDateMonth, endDateDay, endDateYear, endDateHour, endDateMinute, neverEnd, overlapAllowed, startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, dispatchTaskClusterMode);
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, String name, UnicodeProperties taskSettingsUnicodeProperties) throws PortalException {
        _dispatchTriggerModelResourcePermission.check(this.getPermissionChecker(), dispatchTriggerId, "UPDATE");
        return this.dispatchTriggerLocalService.updateDispatchTrigger(dispatchTriggerId, name, taskSettingsUnicodeProperties);
    }
}

