/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.exception.DispatchTriggerEndDateException;
import com.liferay.dispatch.exception.DispatchTriggerNameException;
import com.liferay.dispatch.exception.DispatchTriggerSchedulerException;
import com.liferay.dispatch.exception.DispatchTriggerStartDateException;
import com.liferay.dispatch.exception.DuplicateDispatchTriggerException;
import com.liferay.dispatch.executor.DispatchTaskClusterMode;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchTriggerLocalServiceBaseImpl;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.AuditedModel;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.scheduler.SchedulerEngineHelper;
import com.liferay.portal.kernel.scheduler.SchedulerException;
import com.liferay.portal.kernel.scheduler.StorageType;
import com.liferay.portal.kernel.scheduler.Trigger;
import com.liferay.portal.kernel.scheduler.TriggerFactory;
import com.liferay.portal.kernel.systemevent.SystemEvent;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"model.class.name=com.liferay.dispatch.model.DispatchTrigger"}, service={AopService.class})
public class DispatchTriggerLocalServiceImpl
extends DispatchTriggerLocalServiceBaseImpl {
    private static final Log _log = LogFactoryUtil.getLog(DispatchTriggerLocalServiceImpl.class);
    @Reference
    private Portal _portal;
    @Reference
    private SchedulerEngineHelper _schedulerEngineHelper;
    @Reference
    private TriggerFactory _triggerFactory;

    public DispatchTrigger addDispatchTrigger(long userId, String name, boolean system, String taskExecutorType, UnicodeProperties taskSettingsUnicodeProperties) throws PortalException {
        User user = this.userLocalService.getUser(userId);
        this.validate(0L, user.getCompanyId(), name);
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.create(this.counterLocalService.increment());
        dispatchTrigger.setCompanyId(user.getCompanyId());
        dispatchTrigger.setUserId(user.getUserId());
        dispatchTrigger.setUserName(user.getFullName());
        dispatchTrigger.setName(name);
        dispatchTrigger.setSystem(system);
        dispatchTrigger.setTaskExecutorType(taskExecutorType);
        dispatchTrigger.setTaskSettingsUnicodeProperties(taskSettingsUnicodeProperties);
        dispatchTrigger = (DispatchTrigger)this.dispatchTriggerPersistence.update((BaseModel)dispatchTrigger);
        this.resourceLocalService.addResources(user.getCompanyId(), 0L, user.getUserId(), DispatchTrigger.class.getName(), dispatchTrigger.getDispatchTriggerId(), false, true, true);
        return dispatchTrigger;
    }

    @Override
    @SystemEvent(type=1)
    public DispatchTrigger deleteDispatchTrigger(DispatchTrigger dispatchTrigger) throws PortalException {
        if (dispatchTrigger.isSystem()) {
            return dispatchTrigger;
        }
        this.dispatchLogPersistence.removeByDispatchTriggerId(dispatchTrigger.getDispatchTriggerId());
        this.dispatchTriggerPersistence.remove((BaseModel)dispatchTrigger);
        this.resourceLocalService.deleteResource((AuditedModel)dispatchTrigger, 4);
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getTaskClusterMode());
        this._deleteSchedulerJob(dispatchTrigger.getDispatchTriggerId(), dispatchTaskClusterMode.getStorageType());
        return dispatchTrigger;
    }

    @Override
    public DispatchTrigger deleteDispatchTrigger(long dispatchTriggerId) throws PortalException {
        return this.deleteDispatchTrigger(this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId));
    }

    public DispatchTrigger fetchDispatchTrigger(long companyId, String name) {
        return this.dispatchTriggerPersistence.fetchByC_N(companyId, name);
    }

    @Override
    public DispatchTrigger getDispatchTrigger(long dispatchTriggerId) throws PortalException {
        return this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
    }

    public List<DispatchTrigger> getDispatchTriggers(long companyId, int start, int end) {
        return this.dispatchTriggerPersistence.findByCompanyId(companyId, start, end);
    }

    public int getDispatchTriggersCount(long companyId) {
        return this.dispatchTriggerPersistence.countByCompanyId(companyId);
    }

    public Date getNextFireDate(long dispatchTriggerId) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getTaskClusterMode());
        try {
            return this._schedulerEngineHelper.getNextFireTime(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), dispatchTaskClusterMode.getStorageType());
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)schedulerException, (Throwable)schedulerException);
            return null;
        }
    }

    public Date getPreviousFireDate(long dispatchTriggerId) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        DispatchTaskClusterMode dispatchTaskClusterMode = DispatchTaskClusterMode.valueOf((int)dispatchTrigger.getTaskClusterMode());
        try {
            return this._schedulerEngineHelper.getPreviousFireTime(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), dispatchTaskClusterMode.getStorageType());
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)schedulerException, (Throwable)schedulerException);
            return null;
        }
    }

    public List<DispatchTrigger> getUserDispatchTriggers(long companyId, long userId, int start, int end) {
        return this.dispatchTriggerPersistence.findByC_U(companyId, userId, start, end);
    }

    public int getUserDispatchTriggersCount(long companyId, long userId) {
        return this.dispatchTriggerPersistence.countByC_U(companyId, userId);
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, boolean active, String cronExpression, int endDateMonth, int endDateDay, int endDateYear, int endDateHour, int endDateMinute, boolean neverEnd, boolean overlapAllowed, int startDateMonth, int startDateDay, int startDateYear, int startDateHour, int startDateMinute, DispatchTaskClusterMode dispatchTaskClusterMode) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.fetchByPrimaryKey(dispatchTriggerId);
        dispatchTrigger.setActive(active);
        dispatchTrigger.setCronExpression(cronExpression);
        if (neverEnd) {
            dispatchTrigger.setEndDate(null);
        } else {
            dispatchTrigger.setEndDate(this._portal.getDate(endDateMonth, endDateDay, endDateYear, endDateHour, endDateMinute, DispatchTriggerEndDateException.class));
        }
        dispatchTrigger.setOverlapAllowed(overlapAllowed);
        dispatchTrigger.setStartDate(this._portal.getDate(startDateMonth, startDateDay, startDateYear, startDateHour, startDateMinute, DispatchTriggerStartDateException.class));
        dispatchTrigger.setTaskClusterMode(dispatchTaskClusterMode.getMode());
        dispatchTrigger = (DispatchTrigger)this.dispatchTriggerPersistence.update((BaseModel)dispatchTrigger);
        this._deleteSchedulerJob(dispatchTriggerId, dispatchTaskClusterMode.getStorageType());
        if (active) {
            this._addSchedulerJob(dispatchTriggerId, cronExpression, dispatchTrigger.getStartDate(), dispatchTrigger.getEndDate(), dispatchTaskClusterMode.getStorageType());
        }
        return dispatchTrigger;
    }

    public DispatchTrigger updateDispatchTrigger(long dispatchTriggerId, String name, UnicodeProperties taskSettingsUnicodeProperties) throws PortalException {
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        this.validate(dispatchTriggerId, dispatchTrigger.getCompanyId(), name);
        dispatchTrigger.setName(name);
        dispatchTrigger.setTaskSettingsUnicodeProperties(taskSettingsUnicodeProperties);
        return (DispatchTrigger)this.dispatchTriggerPersistence.update((BaseModel)dispatchTrigger);
    }

    protected void validate(long dispatchTriggerId, long companyId, String name) throws PortalException {
        if (Validator.isNull((String)name)) {
            throw new DispatchTriggerNameException("Dispatch trigger name is null for company ID " + companyId);
        }
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.fetchByC_N(companyId, name);
        if (dispatchTrigger == null) {
            return;
        }
        if (dispatchTriggerId > 0L && dispatchTrigger.getDispatchTriggerId() == dispatchTriggerId) {
            return;
        }
        throw new DuplicateDispatchTriggerException(StringBundler.concat((Object[])new Object[]{"Dispatch trigger name \"", name, "\" already exists for company ID ", companyId}));
    }

    private void _addSchedulerJob(long dispatchTriggerId, String cronExpression, Date startDate, Date endDate, StorageType storageType) throws PortalException {
        Trigger trigger = this._triggerFactory.createTrigger(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), startDate, endDate, cronExpression);
        try {
            this._schedulerEngineHelper.schedule(trigger, storageType, null, "liferay/dispatch/executor", (Object)this._getPayload(dispatchTriggerId), 1000);
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Scheduler entry created for dispatch trigger " + dispatchTriggerId));
            }
        }
        catch (SchedulerException schedulerException) {
            throw new DispatchTriggerSchedulerException("Unable to create scheduler entry for dispatch trigger " + dispatchTriggerId, (Throwable)schedulerException);
        }
    }

    private void _deleteSchedulerJob(long dispatchTriggerId, StorageType storageType) {
        try {
            this._schedulerEngineHelper.delete(this._getJobName(dispatchTriggerId), this._getGroupName(dispatchTriggerId), storageType);
        }
        catch (SchedulerException schedulerException) {
            _log.error((Object)("Unable to delete scheduler entry for dispatch trigger " + dispatchTriggerId), (Throwable)schedulerException);
        }
    }

    private String _getGroupName(long dispatchTriggerId) {
        return String.format("DISPATCH_GROUP_%07d", dispatchTriggerId);
    }

    private String _getJobName(long dispatchTriggerId) {
        return String.format("DISPATCH_JOB_%07d", dispatchTriggerId);
    }

    private String _getPayload(long dispatchTriggerId) {
        return String.format("{\"dispatchTriggerId\": %d}", dispatchTriggerId);
    }
}

