/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.service.impl;

import com.liferay.dispatch.exception.DispatchLogStartDateException;
import com.liferay.dispatch.exception.DispatchLogStatusException;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.base.DispatchLogLocalServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.User;
import java.util.Date;
import java.util.List;
import org.osgi.service.component.annotations.Component;

@Component(property={"model.class.name=com.liferay.dispatch.model.DispatchLog"}, service={AopService.class})
public class DispatchLogLocalServiceImpl
extends DispatchLogLocalServiceBaseImpl {
    public DispatchLog addDispatchLog(long userId, long dispatchTriggerId, Date endDate, String error, String output, Date startDate, DispatchTaskStatus dispatchTaskStatus) throws PortalException {
        this._checkDispatchLogPeriod(startDate, endDate);
        this._checkDispatchTaskStatus(dispatchTaskStatus);
        DispatchTrigger dispatchTrigger = this.dispatchTriggerPersistence.findByPrimaryKey(dispatchTriggerId);
        User user = this.userLocalService.getUser(userId);
        DispatchLog dispatchLog = this.dispatchLogPersistence.create(this.counterLocalService.increment());
        dispatchLog.setCompanyId(user.getCompanyId());
        dispatchLog.setUserId(user.getUserId());
        dispatchLog.setUserName(user.getFullName());
        dispatchLog.setDispatchTriggerId(dispatchTrigger.getDispatchTriggerId());
        dispatchLog.setEndDate(endDate);
        dispatchLog.setError(error);
        dispatchLog.setOutput(output);
        dispatchLog.setStartDate(startDate);
        dispatchLog.setStatus(dispatchTaskStatus.getStatus());
        return (DispatchLog)this.dispatchLogPersistence.update((BaseModel)dispatchLog);
    }

    public void deleteDispatchLogs(long dispatchTriggerId) {
        this.dispatchLogPersistence.removeByDispatchTriggerId(dispatchTriggerId);
    }

    public DispatchLog fetchLatestDispatchLog(long dispatchTriggerId) {
        return this.dispatchLogPersistence.fetchByDispatchTriggerId_First(dispatchTriggerId, null);
    }

    public List<DispatchLog> getDispatchLogs(long dispatchTriggerId, int start, int end) {
        return this.dispatchLogPersistence.findByDispatchTriggerId(dispatchTriggerId, start, end);
    }

    public int getDispatchLogsCount(long dispatchTriggerId) {
        return this.dispatchLogPersistence.countByDispatchTriggerId(dispatchTriggerId);
    }

    public DispatchLog updateDispatchLog(long dispatchLogId, Date endDate, String error, String output, DispatchTaskStatus dispatchTaskStatus) throws PortalException {
        DispatchLog dispatchLog = this.dispatchLogPersistence.findByPrimaryKey(dispatchLogId);
        this._checkDispatchLogPeriod(dispatchLog.getStartDate(), endDate);
        this._checkDispatchTaskStatus(dispatchTaskStatus);
        dispatchLog.setEndDate(endDate);
        dispatchLog.setError(error);
        dispatchLog.setOutput(output);
        dispatchLog.setStatus(dispatchTaskStatus.getStatus());
        return (DispatchLog)this.dispatchLogPersistence.update((BaseModel)dispatchLog);
    }

    private void _checkDispatchLogPeriod(Date startDate, Date endDate) throws PortalException {
        if (startDate == null) {
            throw new DispatchLogStartDateException("Start date is required");
        }
        if (endDate == null) {
            return;
        }
        if (startDate.after(endDate)) {
            throw new DispatchLogStartDateException("Start date must precede end date");
        }
    }

    private void _checkDispatchTaskStatus(DispatchTaskStatus dispatchTaskStatus) throws PortalException {
        if (dispatchTaskStatus == null) {
            throw new DispatchLogStatusException("Dispatch task status is required");
        }
    }
}

