/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.repository;

import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.repository.DispatchFileRepository;
import com.liferay.dispatch.repository.DispatchFileValidator;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portletfilerepository.PortletFileRepository;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import java.io.InputStream;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(configurationPolicy=ConfigurationPolicy.OPTIONAL, service={DispatchFileRepository.class})
public class DispatchFileRepositoryImpl
implements DispatchFileRepository {
    private static final Log _log = LogFactoryUtil.getLog(DispatchFileRepositoryImpl.class);
    @Reference
    private CompanyLocalService _companyLocalService;
    private ServiceTrackerMap<String, DispatchFileValidator> _dispatchFileValidatorServiceTrackerMap;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;
    @Reference
    private PortletFileRepository _portletFileRepository;

    public FileEntry addFileEntry(long userId, long dispatchTriggerId, String fileName, long size, String contentType, InputStream inputStream) throws PortalException {
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.getDispatchTrigger(dispatchTriggerId);
        DispatchFileValidator dispatchFileValidator = this._getFileValidator(dispatchTrigger.getTaskExecutorType());
        dispatchFileValidator.validateExtension(fileName);
        dispatchFileValidator.validateSize(size);
        Company company = this._companyLocalService.getCompany(dispatchTrigger.getCompanyId());
        return this._addFileEntry(company.getGroupId(), userId, dispatchTriggerId, contentType, inputStream);
    }

    public FileEntry fetchFileEntry(long dispatchTriggerId) {
        try {
            DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.getDispatchTrigger(dispatchTriggerId);
            Company company = this._companyLocalService.getCompany(dispatchTrigger.getCompanyId());
            Folder folder = this._getFolder(company.getGroupId(), dispatchTrigger.getUserId());
            return this._portletFileRepository.fetchPortletFileEntry(company.getGroupId(), folder.getFolderId(), String.valueOf(dispatchTriggerId));
        }
        catch (PortalException portalException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to fetch file entry", (Throwable)portalException);
            }
            return null;
        }
    }

    public String fetchFileEntryName(long dispatchTriggerId) {
        FileEntry fileEntry = this.fetchFileEntry(dispatchTriggerId);
        if (fileEntry != null) {
            return fileEntry.getFileName();
        }
        return null;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dispatchFileValidatorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DispatchFileValidator.class, (String)"dispatch.file.validator.type");
    }

    @Deactivate
    protected void deactivate() {
        this._dispatchFileValidatorServiceTrackerMap.close();
    }

    private FileEntry _addFileEntry(long groupId, long userId, long dispatchTriggerId, String contentType, InputStream inputStream) throws PortalException {
        Folder folder = this._getFolder(groupId, userId);
        FileEntry fileEntry = this._portletFileRepository.fetchPortletFileEntry(groupId, folder.getFolderId(), String.valueOf(dispatchTriggerId));
        if (fileEntry != null) {
            this._portletFileRepository.deletePortletFileEntry(fileEntry.getFileEntryId());
        }
        return this._portletFileRepository.addPortletFileEntry(groupId, userId, DispatchTrigger.class.getName(), dispatchTriggerId, "com_liferay_dispatch_web_internal_portlet_DispatchPortlet", folder.getFolderId(), inputStream, String.valueOf(dispatchTriggerId), contentType, false);
    }

    private DispatchFileValidator _getFileValidator(String taskExecutorType) {
        if (this._dispatchFileValidatorServiceTrackerMap.containsKey((Object)taskExecutorType)) {
            return (DispatchFileValidator)this._dispatchFileValidatorServiceTrackerMap.getService((Object)taskExecutorType);
        }
        return (DispatchFileValidator)this._dispatchFileValidatorServiceTrackerMap.getService((Object)"default");
    }

    private Folder _getFolder(long groupId, long userId) throws PortalException {
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setAddGuestPermissions(true);
        Repository repository = this._portletFileRepository.addPortletRepository(groupId, "com_liferay_dispatch_web_internal_portlet_DispatchPortlet", serviceContext);
        return this._portletFileRepository.addPortletFolder(userId, repository.getRepositoryId(), 0L, "dispatch", serviceContext);
    }
}

