/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.internal.messaging;

import com.liferay.dispatch.executor.DispatchTaskExecutor;
import com.liferay.dispatch.executor.DispatchTaskStatus;
import com.liferay.dispatch.model.DispatchLog;
import com.liferay.dispatch.model.DispatchTrigger;
import com.liferay.dispatch.service.DispatchLogLocalService;
import com.liferay.dispatch.service.DispatchTriggerLocalService;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMap;
import com.liferay.osgi.service.tracker.collections.map.ServiceTrackerMapFactory;
import com.liferay.portal.kernel.json.JSONFactoryUtil;
import com.liferay.portal.kernel.json.JSONObject;
import com.liferay.portal.kernel.messaging.BaseMessageListener;
import com.liferay.portal.kernel.messaging.Message;
import com.liferay.portal.kernel.messaging.MessageListener;
import java.util.Date;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(property={"destination.name=liferay/dispatch/executor"}, service={MessageListener.class})
public class DispatchMessageListener
extends BaseMessageListener {
    @Reference
    private DispatchLogLocalService _dispatchLogLocalService;
    private ServiceTrackerMap<String, DispatchTaskExecutor> _dispatchTaskExecutorServiceTrackerMap;
    @Reference
    private DispatchTriggerLocalService _dispatchTriggerLocalService;

    public void doReceive(Message message) throws Exception {
        DispatchLog dispatchLog;
        String payload = (String)message.getPayload();
        JSONObject jsonObject = JSONFactoryUtil.createJSONObject((String)payload);
        long dispatchTriggerId = jsonObject.getLong("dispatchTriggerId");
        DispatchTrigger dispatchTrigger = this._dispatchTriggerLocalService.getDispatchTrigger(dispatchTriggerId);
        if (!dispatchTrigger.isOverlapAllowed() && (dispatchLog = this._dispatchLogLocalService.fetchLatestDispatchLog(dispatchTriggerId)) != null && DispatchTaskStatus.valueOf((int)dispatchLog.getStatus()) == DispatchTaskStatus.IN_PROGRESS) {
            this._dispatchLogLocalService.addDispatchLog(dispatchTrigger.getUserId(), dispatchTrigger.getDispatchTriggerId(), null, null, null, new Date(), DispatchTaskStatus.CANCELED);
            return;
        }
        DispatchTaskExecutor dispatchTaskExecutor = (DispatchTaskExecutor)this._dispatchTaskExecutorServiceTrackerMap.getService((Object)dispatchTrigger.getTaskExecutorType());
        dispatchTaskExecutor.execute(dispatchTriggerId);
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dispatchTaskExecutorServiceTrackerMap = ServiceTrackerMapFactory.openSingleValueMap((BundleContext)bundleContext, DispatchTaskExecutor.class, (String)"dispatch.task.executor.type");
    }

    @Deactivate
    protected void deactivate() {
        this._dispatchTaskExecutorServiceTrackerMap.close();
    }
}

