/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.persistence.impl;

import com.liferay.depot.exception.NoSuchAppCustomizationException;
import com.liferay.depot.model.DepotAppCustomization;
import com.liferay.depot.model.DepotAppCustomizationTable;
import com.liferay.depot.model.impl.DepotAppCustomizationImpl;
import com.liferay.depot.model.impl.DepotAppCustomizationModelImpl;
import com.liferay.depot.service.persistence.DepotAppCustomizationPersistence;
import com.liferay.depot.service.persistence.DepotAppCustomizationUtil;
import com.liferay.petra.lang.SafeCloseable;
import com.liferay.petra.sql.dsl.Table;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.change.tracking.CTCollectionThreadLocal;
import com.liferay.portal.kernel.change.tracking.CTColumnResolutionType;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.change.tracking.CTModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.helper.CTPersistenceHelper;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DepotAppCustomizationPersistence.class})
public class DepotAppCustomizationPersistenceImpl
extends BasePersistenceImpl<DepotAppCustomization>
implements DepotAppCustomizationPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DepotAppCustomizationImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByDepotEntryId;
    private FinderPath _finderPathWithoutPaginationFindByDepotEntryId;
    private FinderPath _finderPathCountByDepotEntryId;
    private static final String _FINDER_COLUMN_DEPOTENTRYID_DEPOTENTRYID_2 = "depotAppCustomization.depotEntryId = ?";
    private FinderPath _finderPathFetchByD_E;
    private static final String _FINDER_COLUMN_D_E_DEPOTENTRYID_2 = "depotAppCustomization.depotEntryId = ? AND ";
    private static final String _FINDER_COLUMN_D_E_ENABLED_2 = "depotAppCustomization.enabled = ?";
    private FinderPath _finderPathFetchByD_P;
    private static final String _FINDER_COLUMN_D_P_DEPOTENTRYID_2 = "depotAppCustomization.depotEntryId = ? AND ";
    private static final String _FINDER_COLUMN_D_P_PORTLETID_2 = "depotAppCustomization.portletId = ?";
    private static final String _FINDER_COLUMN_D_P_PORTLETID_3 = "(depotAppCustomization.portletId IS NULL OR depotAppCustomization.portletId = '')";
    private int _valueObjectFinderCacheListThreshold;
    private static final Map<CTColumnResolutionType, Set<String>> _ctColumnNamesMap = new EnumMap<CTColumnResolutionType, Set<String>>(CTColumnResolutionType.class);
    private static final List<String> _mappingTableNames = new ArrayList<String>();
    private static final List<String[]> _uniqueIndexColumnNames = new ArrayList<String[]>();
    @Reference
    protected CTPersistenceHelper ctPersistenceHelper;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DEPOTAPPCUSTOMIZATION = "SELECT depotAppCustomization FROM DepotAppCustomization depotAppCustomization";
    private static final String _SQL_SELECT_DEPOTAPPCUSTOMIZATION_WHERE = "SELECT depotAppCustomization FROM DepotAppCustomization depotAppCustomization WHERE ";
    private static final String _SQL_COUNT_DEPOTAPPCUSTOMIZATION = "SELECT COUNT(depotAppCustomization) FROM DepotAppCustomization depotAppCustomization";
    private static final String _SQL_COUNT_DEPOTAPPCUSTOMIZATION_WHERE = "SELECT COUNT(depotAppCustomization) FROM DepotAppCustomization depotAppCustomization WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "depotAppCustomization.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DepotAppCustomization exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DepotAppCustomization exists with the key {";
    private static final Log _log;

    public List<DepotAppCustomization> findByDepotEntryId(long depotEntryId) {
        return this.findByDepotEntryId(depotEntryId, -1, -1, null);
    }

    public List<DepotAppCustomization> findByDepotEntryId(long depotEntryId, int start, int end) {
        return this.findByDepotEntryId(depotEntryId, start, end, null);
    }

    public List<DepotAppCustomization> findByDepotEntryId(long depotEntryId, int start, int end, OrderByComparator<DepotAppCustomization> orderByComparator) {
        return this.findByDepotEntryId(depotEntryId, start, end, orderByComparator, true);
    }

    public List<DepotAppCustomization> findByDepotEntryId(long depotEntryId, int start, int end, OrderByComparator<DepotAppCustomization> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindByDepotEntryId;
                    finderArgs = new Object[]{depotEntryId};
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindByDepotEntryId;
                finderArgs = new Object[]{depotEntryId, start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this)) != null && !list.isEmpty()) {
                for (DepotAppCustomization depotAppCustomization : list) {
                    if (depotEntryId == depotAppCustomization.getDepotEntryId()) continue;
                    list = null;
                    break;
                }
            }
            if (list == null) {
                StringBundler sb = null;
                sb = orderByComparator != null ? new StringBundler(3 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(3);
                sb.append(_SQL_SELECT_DEPOTAPPCUSTOMIZATION_WHERE);
                sb.append(_FINDER_COLUMN_DEPOTENTRYID_DEPOTENTRYID_2);
                if (orderByComparator != null) {
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                } else {
                    sb.append(" ORDER BY depotAppCustomization.depotAppCustomizationId ASC");
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(depotEntryId);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public DepotAppCustomization findByDepotEntryId_First(long depotEntryId, OrderByComparator<DepotAppCustomization> orderByComparator) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.fetchByDepotEntryId_First(depotEntryId, orderByComparator);
        if (depotAppCustomization != null) {
            return depotAppCustomization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("depotEntryId=");
        sb.append(depotEntryId);
        sb.append("}");
        throw new NoSuchAppCustomizationException(sb.toString());
    }

    public DepotAppCustomization fetchByDepotEntryId_First(long depotEntryId, OrderByComparator<DepotAppCustomization> orderByComparator) {
        List<DepotAppCustomization> list = this.findByDepotEntryId(depotEntryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DepotAppCustomization findByDepotEntryId_Last(long depotEntryId, OrderByComparator<DepotAppCustomization> orderByComparator) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.fetchByDepotEntryId_Last(depotEntryId, orderByComparator);
        if (depotAppCustomization != null) {
            return depotAppCustomization;
        }
        StringBundler sb = new StringBundler(4);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("depotEntryId=");
        sb.append(depotEntryId);
        sb.append("}");
        throw new NoSuchAppCustomizationException(sb.toString());
    }

    public DepotAppCustomization fetchByDepotEntryId_Last(long depotEntryId, OrderByComparator<DepotAppCustomization> orderByComparator) {
        int count = this.countByDepotEntryId(depotEntryId);
        if (count == 0) {
            return null;
        }
        List<DepotAppCustomization> list = this.findByDepotEntryId(depotEntryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DepotAppCustomization[] findByDepotEntryId_PrevAndNext(long depotAppCustomizationId, long depotEntryId, OrderByComparator<DepotAppCustomization> orderByComparator) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.findByPrimaryKey(depotAppCustomizationId);
        Session session = null;
        try {
            session = this.openSession();
            DepotAppCustomization[] array = new DepotAppCustomizationImpl[]{this.getByDepotEntryId_PrevAndNext(session, depotAppCustomization, depotEntryId, orderByComparator, true), depotAppCustomization, this.getByDepotEntryId_PrevAndNext(session, depotAppCustomization, depotEntryId, orderByComparator, false)};
            DepotAppCustomization[] depotAppCustomizationArray = array;
            return depotAppCustomizationArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DepotAppCustomization getByDepotEntryId_PrevAndNext(Session session, DepotAppCustomization depotAppCustomization, long depotEntryId, OrderByComparator<DepotAppCustomization> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(3);
        sb.append(_SQL_SELECT_DEPOTAPPCUSTOMIZATION_WHERE);
        sb.append(_FINDER_COLUMN_DEPOTENTRYID_DEPOTENTRYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY depotAppCustomization.depotAppCustomizationId ASC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(depotEntryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)depotAppCustomization)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DepotAppCustomization)list.get(1);
        }
        return null;
    }

    public void removeByDepotEntryId(long depotEntryId) {
        for (DepotAppCustomization depotAppCustomization : this.findByDepotEntryId(depotEntryId, -1, -1, null)) {
            this.remove((BaseModel)depotAppCustomization);
        }
    }

    public int countByDepotEntryId(long depotEntryId) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class);){
            FinderPath finderPath = this._finderPathCountByDepotEntryId;
            Object[] finderArgs = new Object[]{depotEntryId};
            Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            if (count == null) {
                StringBundler sb = new StringBundler(2);
                sb.append(_SQL_COUNT_DEPOTAPPCUSTOMIZATION_WHERE);
                sb.append(_FINDER_COLUMN_DEPOTENTRYID_DEPOTENTRYID_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(depotEntryId);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(finderPath, finderArgs, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    public DepotAppCustomization findByD_E(long depotEntryId, boolean enabled) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.fetchByD_E(depotEntryId, enabled);
        if (depotAppCustomization == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("depotEntryId=");
            sb.append(depotEntryId);
            sb.append(", enabled=");
            sb.append(enabled);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchAppCustomizationException(sb.toString());
        }
        return depotAppCustomization;
    }

    public DepotAppCustomization fetchByD_E(long depotEntryId, boolean enabled) {
        return this.fetchByD_E(depotEntryId, enabled, true);
    }

    public DepotAppCustomization fetchByD_E(long depotEntryId, boolean enabled, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class);){
            DepotAppCustomization depotAppCustomization;
            DepotAppCustomization depotAppCustomization2;
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{depotEntryId, enabled};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByD_E, finderArgs, (BasePersistence)this);
            }
            if (result instanceof DepotAppCustomization && (depotEntryId != (depotAppCustomization2 = (DepotAppCustomization)result).getDepotEntryId() || enabled != depotAppCustomization2.isEnabled())) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(4);
                sb.append(_SQL_SELECT_DEPOTAPPCUSTOMIZATION_WHERE);
                sb.append("depotAppCustomization.depotEntryId = ? AND ");
                sb.append(_FINDER_COLUMN_D_E_ENABLED_2);
                String sql = sb.toString();
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(depotEntryId);
                    queryPos.add(enabled);
                    List list = query.list();
                    if (list.isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByD_E, finderArgs, (Object)list);
                        }
                    } else {
                        if (list.size() > 1) {
                            Collections.sort(list, Collections.reverseOrder());
                            if (_log.isWarnEnabled()) {
                                if (!useFinderCache) {
                                    finderArgs = new Object[]{depotEntryId, enabled};
                                }
                                _log.warn((Object)("DepotAppCustomizationPersistenceImpl.fetchByD_E(long, boolean, boolean) with parameters (" + StringUtil.merge((Object[])finderArgs) + ") yields a result set with more than 1 result. This violates the logical unique restriction. There is no order guarantee on which result is returned by this finder."));
                            }
                        }
                        DepotAppCustomization depotAppCustomization3 = (DepotAppCustomization)list.get(0);
                        result = depotAppCustomization3;
                        this.cacheResult(depotAppCustomization3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                depotAppCustomization = null;
                return depotAppCustomization;
            }
            depotAppCustomization = (DepotAppCustomization)result;
            return depotAppCustomization;
        }
    }

    public DepotAppCustomization removeByD_E(long depotEntryId, boolean enabled) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.findByD_E(depotEntryId, enabled);
        return (DepotAppCustomization)this.remove((BaseModel)depotAppCustomization);
    }

    public int countByD_E(long depotEntryId, boolean enabled) {
        DepotAppCustomization depotAppCustomization = this.fetchByD_E(depotEntryId, enabled);
        if (depotAppCustomization == null) {
            return 0;
        }
        return 1;
    }

    public DepotAppCustomization findByD_P(long depotEntryId, String portletId) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.fetchByD_P(depotEntryId, portletId);
        if (depotAppCustomization == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("depotEntryId=");
            sb.append(depotEntryId);
            sb.append(", portletId=");
            sb.append(portletId);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchAppCustomizationException(sb.toString());
        }
        return depotAppCustomization;
    }

    public DepotAppCustomization fetchByD_P(long depotEntryId, String portletId) {
        return this.fetchByD_P(depotEntryId, portletId, true);
    }

    public DepotAppCustomization fetchByD_P(long depotEntryId, String portletId, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class);){
            DepotAppCustomization depotAppCustomization;
            DepotAppCustomization depotAppCustomization2;
            portletId = Objects.toString(portletId, "");
            Object[] finderArgs = null;
            if (useFinderCache) {
                finderArgs = new Object[]{depotEntryId, portletId};
            }
            Object result = null;
            if (useFinderCache) {
                result = this.finderCache.getResult(this._finderPathFetchByD_P, finderArgs, (BasePersistence)this);
            }
            if (result instanceof DepotAppCustomization && (depotEntryId != (depotAppCustomization2 = (DepotAppCustomization)result).getDepotEntryId() || !Objects.equals(portletId, depotAppCustomization2.getPortletId()))) {
                result = null;
            }
            if (result == null) {
                StringBundler sb = new StringBundler(4);
                sb.append(_SQL_SELECT_DEPOTAPPCUSTOMIZATION_WHERE);
                sb.append("depotAppCustomization.depotEntryId = ? AND ");
                boolean bindPortletId = false;
                if (portletId.isEmpty()) {
                    sb.append(_FINDER_COLUMN_D_P_PORTLETID_3);
                } else {
                    bindPortletId = true;
                    sb.append(_FINDER_COLUMN_D_P_PORTLETID_2);
                }
                String sql = sb.toString();
                Session session = null;
                try {
                    List list;
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    QueryPos queryPos = QueryPos.getInstance((Query)query);
                    queryPos.add(depotEntryId);
                    if (bindPortletId) {
                        queryPos.add(portletId);
                    }
                    if ((list = query.list()).isEmpty()) {
                        if (useFinderCache) {
                            this.finderCache.putResult(this._finderPathFetchByD_P, finderArgs, (Object)list);
                        }
                    } else {
                        DepotAppCustomization depotAppCustomization3 = (DepotAppCustomization)list.get(0);
                        result = depotAppCustomization3;
                        this.cacheResult(depotAppCustomization3);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            if (result instanceof List) {
                depotAppCustomization = null;
                return depotAppCustomization;
            }
            depotAppCustomization = (DepotAppCustomization)result;
            return depotAppCustomization;
        }
    }

    public DepotAppCustomization removeByD_P(long depotEntryId, String portletId) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.findByD_P(depotEntryId, portletId);
        return (DepotAppCustomization)this.remove((BaseModel)depotAppCustomization);
    }

    public int countByD_P(long depotEntryId, String portletId) {
        DepotAppCustomization depotAppCustomization = this.fetchByD_P(depotEntryId, portletId);
        if (depotAppCustomization == null) {
            return 0;
        }
        return 1;
    }

    public DepotAppCustomizationPersistenceImpl() {
        this.setModelClass(DepotAppCustomization.class);
        this.setModelImplClass(DepotAppCustomizationImpl.class);
        this.setModelPKClass(Long.TYPE);
        this.setTable((Table)DepotAppCustomizationTable.INSTANCE);
    }

    public void cacheResult(DepotAppCustomization depotAppCustomization) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)depotAppCustomization.getCtCollectionId());){
            this.entityCache.putResult(DepotAppCustomizationImpl.class, (Serializable)Long.valueOf(depotAppCustomization.getPrimaryKey()), (Serializable)depotAppCustomization);
            this.finderCache.putResult(this._finderPathFetchByD_E, new Object[]{depotAppCustomization.getDepotEntryId(), depotAppCustomization.isEnabled()}, (Object)depotAppCustomization);
            this.finderCache.putResult(this._finderPathFetchByD_P, new Object[]{depotAppCustomization.getDepotEntryId(), depotAppCustomization.getPortletId()}, (Object)depotAppCustomization);
        }
    }

    public void cacheResult(List<DepotAppCustomization> depotAppCustomizations) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && depotAppCustomizations.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (DepotAppCustomization depotAppCustomization : depotAppCustomizations) {
            SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)depotAppCustomization.getCtCollectionId());
            try {
                if (this.entityCache.getResult(DepotAppCustomizationImpl.class, (Serializable)Long.valueOf(depotAppCustomization.getPrimaryKey())) != null) continue;
                this.cacheResult(depotAppCustomization);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DepotAppCustomizationImpl.class);
        this.finderCache.clearCache(DepotAppCustomizationImpl.class);
    }

    public void clearCache(DepotAppCustomization depotAppCustomization) {
        this.entityCache.removeResult(DepotAppCustomizationImpl.class, (BaseModel)depotAppCustomization);
    }

    public void clearCache(List<DepotAppCustomization> depotAppCustomizations) {
        for (DepotAppCustomization depotAppCustomization : depotAppCustomizations) {
            this.entityCache.removeResult(DepotAppCustomizationImpl.class, (BaseModel)depotAppCustomization);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(DepotAppCustomizationImpl.class);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(DepotAppCustomizationImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DepotAppCustomizationModelImpl depotAppCustomizationModelImpl) {
        try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setCTCollectionIdWithSafeCloseable((long)depotAppCustomizationModelImpl.getCtCollectionId());){
            Object[] args = new Object[]{depotAppCustomizationModelImpl.getDepotEntryId(), depotAppCustomizationModelImpl.isEnabled()};
            this.finderCache.putResult(this._finderPathFetchByD_E, args, (Object)depotAppCustomizationModelImpl);
            args = new Object[]{depotAppCustomizationModelImpl.getDepotEntryId(), depotAppCustomizationModelImpl.getPortletId()};
            this.finderCache.putResult(this._finderPathFetchByD_P, args, (Object)depotAppCustomizationModelImpl);
        }
    }

    public DepotAppCustomization create(long depotAppCustomizationId) {
        DepotAppCustomizationImpl depotAppCustomization = new DepotAppCustomizationImpl();
        depotAppCustomization.setNew(true);
        depotAppCustomization.setPrimaryKey(depotAppCustomizationId);
        depotAppCustomization.setCompanyId(CompanyThreadLocal.getCompanyId());
        return depotAppCustomization;
    }

    public DepotAppCustomization remove(long depotAppCustomizationId) throws NoSuchAppCustomizationException {
        return this.remove(Long.valueOf(depotAppCustomizationId));
    }

    public DepotAppCustomization remove(Serializable primaryKey) throws NoSuchAppCustomizationException {
        Session session = null;
        try {
            session = this.openSession();
            DepotAppCustomization depotAppCustomization = (DepotAppCustomization)session.get(DepotAppCustomizationImpl.class, primaryKey);
            if (depotAppCustomization == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
                }
                throw new NoSuchAppCustomizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
            }
            DepotAppCustomization depotAppCustomization2 = (DepotAppCustomization)this.remove((BaseModel)depotAppCustomization);
            return depotAppCustomization2;
        }
        catch (NoSuchAppCustomizationException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DepotAppCustomization removeImpl(DepotAppCustomization depotAppCustomization) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)depotAppCustomization)) {
                depotAppCustomization = (DepotAppCustomization)session.get(DepotAppCustomizationImpl.class, depotAppCustomization.getPrimaryKeyObj());
            }
            if (depotAppCustomization != null && this.ctPersistenceHelper.isRemove((CTModel)depotAppCustomization)) {
                session.delete((Object)depotAppCustomization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (depotAppCustomization != null) {
            this.clearCache(depotAppCustomization);
        }
        return depotAppCustomization;
    }

    public DepotAppCustomization updateImpl(DepotAppCustomization depotAppCustomization) {
        boolean isNew = depotAppCustomization.isNew();
        if (!(depotAppCustomization instanceof DepotAppCustomizationModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass((Class)depotAppCustomization.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)depotAppCustomization);
                throw new IllegalArgumentException("Implement ModelWrapper in depotAppCustomization proxy " + String.valueOf(invocationHandler.getClass()));
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DepotAppCustomization implementation " + String.valueOf(depotAppCustomization.getClass()));
        }
        DepotAppCustomizationModelImpl depotAppCustomizationModelImpl = (DepotAppCustomizationModelImpl)depotAppCustomization;
        Session session = null;
        try {
            session = this.openSession();
            if (this.ctPersistenceHelper.isInsert((CTModel)depotAppCustomization)) {
                if (!isNew) {
                    session.evict(DepotAppCustomizationImpl.class, depotAppCustomization.getPrimaryKeyObj());
                }
                session.save((Object)depotAppCustomization);
            } else {
                depotAppCustomization = (DepotAppCustomization)session.merge((Object)depotAppCustomization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.entityCache.putResult(DepotAppCustomizationImpl.class, (BaseModel)depotAppCustomizationModelImpl, false, true);
        this.cacheUniqueFindersCache(depotAppCustomizationModelImpl);
        if (isNew) {
            depotAppCustomization.setNew(false);
        }
        depotAppCustomization.resetOriginalValues();
        return depotAppCustomization;
    }

    public DepotAppCustomization findByPrimaryKey(Serializable primaryKey) throws NoSuchAppCustomizationException {
        DepotAppCustomization depotAppCustomization = this.fetchByPrimaryKey(primaryKey);
        if (depotAppCustomization == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey)));
            }
            throw new NoSuchAppCustomizationException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + String.valueOf(primaryKey));
        }
        return depotAppCustomization;
    }

    public DepotAppCustomization findByPrimaryKey(long depotAppCustomizationId) throws NoSuchAppCustomizationException {
        return this.findByPrimaryKey(Long.valueOf(depotAppCustomizationId));
    }

    public DepotAppCustomization fetchByPrimaryKey(Serializable primaryKey) {
        if (this.ctPersistenceHelper.isProductionMode(DepotAppCustomization.class, primaryKey)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                DepotAppCustomization depotAppCustomization = (DepotAppCustomization)super.fetchByPrimaryKey(primaryKey);
                return depotAppCustomization;
            }
        }
        DepotAppCustomization depotAppCustomization = (DepotAppCustomization)this.entityCache.getResult(DepotAppCustomizationImpl.class, primaryKey);
        if (depotAppCustomization != null) {
            return depotAppCustomization;
        }
        Session session = null;
        try {
            session = this.openSession();
            depotAppCustomization = (DepotAppCustomization)session.get(DepotAppCustomizationImpl.class, primaryKey);
            if (depotAppCustomization != null) {
                this.cacheResult(depotAppCustomization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return depotAppCustomization;
    }

    public DepotAppCustomization fetchByPrimaryKey(long depotAppCustomizationId) {
        return this.fetchByPrimaryKey(Long.valueOf(depotAppCustomizationId));
    }

    public Map<Serializable, DepotAppCustomization> fetchByPrimaryKeys(Set<Serializable> primaryKeys) {
        if (this.ctPersistenceHelper.isProductionMode(DepotAppCustomization.class)) {
            try (SafeCloseable safeCloseable = CTCollectionThreadLocal.setProductionModeWithSafeCloseable();){
                Map map = super.fetchByPrimaryKeys(primaryKeys);
                return map;
            }
        }
        if (primaryKeys.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<Serializable, DepotAppCustomization> map = new HashMap<Serializable, DepotAppCustomization>();
        if (primaryKeys.size() == 1) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            Serializable primaryKey = iterator.next();
            DepotAppCustomization depotAppCustomization = this.fetchByPrimaryKey(primaryKey);
            if (depotAppCustomization != null) {
                map.put(primaryKey, depotAppCustomization);
            }
            return map;
        }
        HashSet<Serializable> uncachedPrimaryKeys = null;
        for (Serializable primaryKey : primaryKeys) {
            SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class, primaryKey);
            try {
                DepotAppCustomization depotAppCustomization = (DepotAppCustomization)this.entityCache.getResult(DepotAppCustomizationImpl.class, primaryKey);
                if (depotAppCustomization == null) {
                    if (uncachedPrimaryKeys == null) {
                        uncachedPrimaryKeys = new HashSet<Serializable>();
                    }
                    uncachedPrimaryKeys.add(primaryKey);
                    continue;
                }
                map.put(primaryKey, depotAppCustomization);
            }
            finally {
                if (safeCloseable == null) continue;
                safeCloseable.close();
            }
        }
        if (uncachedPrimaryKeys == null) {
            return map;
        }
        if (this.databaseInMaxParameters > 0 && primaryKeys.size() > this.databaseInMaxParameters) {
            Iterator<Serializable> iterator = primaryKeys.iterator();
            while (iterator.hasNext()) {
                HashSet<Serializable> page = new HashSet<Serializable>();
                for (int i = 0; i < this.databaseInMaxParameters && iterator.hasNext(); ++i) {
                    page.add(iterator.next());
                }
                map.putAll(this.fetchByPrimaryKeys(page));
            }
            return map;
        }
        StringBundler sb = new StringBundler(primaryKeys.size() * 2 + 1);
        sb.append(this.getSelectSQL());
        sb.append(" WHERE ");
        sb.append(this.getPKDBName());
        sb.append(" IN (");
        for (Serializable primaryKey : primaryKeys) {
            sb.append(((Long)primaryKey).longValue());
            sb.append(",");
        }
        sb.setIndex(sb.index() - 1);
        sb.append(")");
        String sql = sb.toString();
        Session session = null;
        try {
            session = this.openSession();
            Query query = session.createQuery(sql);
            for (DepotAppCustomization depotAppCustomization : query.list()) {
                map.put(depotAppCustomization.getPrimaryKeyObj(), depotAppCustomization);
                this.cacheResult(depotAppCustomization);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        return map;
    }

    public List<DepotAppCustomization> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DepotAppCustomization> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DepotAppCustomization> findAll(int start, int end, OrderByComparator<DepotAppCustomization> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DepotAppCustomization> findAll(int start, int end, OrderByComparator<DepotAppCustomization> orderByComparator, boolean useFinderCache) {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class);){
            FinderPath finderPath = null;
            Object[] finderArgs = null;
            if (start == -1 && end == -1 && orderByComparator == null) {
                if (useFinderCache) {
                    finderPath = this._finderPathWithoutPaginationFindAll;
                    finderArgs = FINDER_ARGS_EMPTY;
                }
            } else if (useFinderCache) {
                finderPath = this._finderPathWithPaginationFindAll;
                finderArgs = new Object[]{start, end, orderByComparator};
            }
            List list = null;
            if (useFinderCache) {
                list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistence)this);
            }
            if (list == null) {
                StringBundler sb = null;
                String sql = null;
                if (orderByComparator != null) {
                    sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                    sb.append(_SQL_SELECT_DEPOTAPPCUSTOMIZATION);
                    this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                    sql = sb.toString();
                } else {
                    sql = _SQL_SELECT_DEPOTAPPCUSTOMIZATION;
                    sql = sql.concat(" ORDER BY depotAppCustomization.depotAppCustomizationId ASC");
                }
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(sql);
                    list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                    this.cacheResult(list);
                    if (useFinderCache) {
                        this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                    }
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            List list2 = list;
            return list2;
        }
    }

    public void removeAll() {
        for (DepotAppCustomization depotAppCustomization : this.findAll()) {
            this.remove((BaseModel)depotAppCustomization);
        }
    }

    public int countAll() {
        try (SafeCloseable safeCloseable = this.ctPersistenceHelper.setCTCollectionIdWithSafeCloseable(DepotAppCustomization.class);){
            Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistence)this);
            if (count == null) {
                Session session = null;
                try {
                    session = this.openSession();
                    Query query = session.createQuery(_SQL_COUNT_DEPOTAPPCUSTOMIZATION);
                    count = (Long)query.uniqueResult();
                    this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
                }
                catch (Exception exception) {
                    throw this.processException(exception);
                }
                finally {
                    this.closeSession(session);
                }
            }
            int n = count.intValue();
            return n;
        }
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "depotAppCustomizationId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DEPOTAPPCUSTOMIZATION;
    }

    public Set<String> getCTColumnNames(CTColumnResolutionType ctColumnResolutionType) {
        return _ctColumnNamesMap.getOrDefault(ctColumnResolutionType, Collections.emptySet());
    }

    public List<String> getMappingTableNames() {
        return _mappingTableNames;
    }

    public Map<String, Integer> getTableColumnsMap() {
        return DepotAppCustomizationModelImpl.TABLE_COLUMNS_MAP;
    }

    public String getTableName() {
        return "DepotAppCustomization";
    }

    public List<String[]> getUniqueIndexColumnNames() {
        return _uniqueIndexColumnNames;
    }

    @Activate
    public void activate() {
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathWithoutPaginationFindAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0], new String[0], true);
        this._finderPathCountAll = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0], new String[0], false);
        this._finderPathWithPaginationFindByDepotEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByDepotEntryId", new String[]{Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()}, new String[]{"depotEntryId"}, true);
        this._finderPathWithoutPaginationFindByDepotEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByDepotEntryId", new String[]{Long.class.getName()}, new String[]{"depotEntryId"}, true);
        this._finderPathCountByDepotEntryId = new FinderPath(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByDepotEntryId", new String[]{Long.class.getName()}, new String[]{"depotEntryId"}, false);
        this._finderPathFetchByD_E = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByD_E", new String[]{Long.class.getName(), Boolean.class.getName()}, new String[]{"depotEntryId", "enabled"}, true);
        this._finderPathFetchByD_P = new FinderPath(FINDER_CLASS_NAME_ENTITY, "fetchByD_P", new String[]{Long.class.getName(), String.class.getName()}, new String[]{"depotEntryId", "portletId"}, true);
        DepotAppCustomizationUtil.setPersistence((DepotAppCustomizationPersistence)this);
    }

    @Deactivate
    public void deactivate() {
        DepotAppCustomizationUtil.setPersistence(null);
        this.entityCache.removeCache(DepotAppCustomizationImpl.class.getName());
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.depot.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.depot.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.depot.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }

    protected FinderCache getFinderCache() {
        return this.finderCache;
    }

    static {
        HashSet<String> ctControlColumnNames = new HashSet<String>();
        HashSet<String> ctMergeColumnNames = new HashSet<String>();
        HashSet<String> ctStrictColumnNames = new HashSet<String>();
        ctControlColumnNames.add("mvccVersion");
        ctControlColumnNames.add("ctCollectionId");
        ctStrictColumnNames.add("companyId");
        ctMergeColumnNames.add("depotEntryId");
        ctMergeColumnNames.add("enabled");
        ctMergeColumnNames.add("portletId");
        _ctColumnNamesMap.put(CTColumnResolutionType.CONTROL, ctControlColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.MERGE, ctMergeColumnNames);
        _ctColumnNamesMap.put(CTColumnResolutionType.PK, Collections.singleton("depotAppCustomizationId"));
        _ctColumnNamesMap.put(CTColumnResolutionType.STRICT, ctStrictColumnNames);
        _uniqueIndexColumnNames.add(new String[]{"depotEntryId", "portletId"});
        _log = LogFactoryUtil.getLog(DepotAppCustomizationPersistenceImpl.class);
    }
}

