/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.service.impl;

import com.liferay.depot.model.DepotEntry;
import com.liferay.depot.service.base.DepotEntryServiceBaseImpl;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.ClassedModel;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.PortletResourcePermission;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.permission.GroupPermissionUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(property={"json.web.service.context.name=depot", "json.web.service.context.path=DepotEntry"}, service={AopService.class})
public class DepotEntryServiceImpl
extends DepotEntryServiceBaseImpl {
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(model.class.name=com.liferay.depot.model.DepotEntry)")
    private volatile ModelResourcePermission<DepotEntry> _depotEntryModelResourcePermission;
    @Reference(policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY, target="(resource.name=com.liferay.depot)")
    private volatile PortletResourcePermission _portletResourcePermission;

    public DepotEntry addDepotEntry(Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, int type, ServiceContext serviceContext) throws PortalException {
        this._portletResourcePermission.check(this.getPermissionChecker(), serviceContext.getScopeGroupId(), "ADD_DEPOT_ENTRY");
        return this.depotEntryLocalService.addDepotEntry(nameMap, descriptionMap, type, serviceContext);
    }

    public DepotEntry deleteDepotEntry(long depotEntryId) throws PortalException {
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryId, "DELETE");
        return this.depotEntryLocalService.deleteDepotEntry(depotEntryId);
    }

    public DepotEntry fetchGroupDepotEntry(long groupId) throws PortalException {
        DepotEntry depotEntry = this.depotEntryLocalService.fetchGroupDepotEntry(groupId);
        if (depotEntry != null) {
            this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)depotEntry, "VIEW");
        }
        return depotEntry;
    }

    public List<DepotEntry> getCurrentAndGroupConnectedDepotEntries(long groupId, int type, int start, int end) throws PortalException {
        List<DepotEntry> filteredDepotEntries = this.getGroupConnectedDepotEntries(groupId, type, start, end);
        DepotEntry depotEntry = this.depotEntryLocalService.fetchGroupDepotEntry(groupId);
        if (depotEntry != null) {
            filteredDepotEntries.add(depotEntry);
        }
        return filteredDepotEntries;
    }

    public DepotEntry getDepotEntry(long depotEntryId) throws PortalException {
        if (!this._depotEntryModelResourcePermission.contains(this.getPermissionChecker(), depotEntryId, "VIEW") && !this._depotEntryModelResourcePermission.contains(this.getPermissionChecker(), depotEntryId, "VIEW_SITE_ADMINISTRATION")) {
            this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryId, "VIEW");
        }
        return this.depotEntryLocalService.getDepotEntry(depotEntryId);
    }

    public List<DepotEntry> getGroupConnectedDepotEntries(long groupId, boolean ddmStructuresAvailable, int start, int end) throws PortalException {
        if (!GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        return this.depotEntryLocalService.getGroupConnectedDepotEntries(groupId, ddmStructuresAvailable, start, end);
    }

    public List<DepotEntry> getGroupConnectedDepotEntries(long groupId, int type, int start, int end) throws PortalException {
        PermissionChecker permissionChecker = this.getPermissionChecker();
        if (!GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)groupId, (String)"VIEW")) {
            return Collections.emptyList();
        }
        ArrayList<DepotEntry> filteredDepotEntries = new ArrayList<DepotEntry>();
        for (DepotEntry depotEntry : this.depotEntryLocalService.getGroupConnectedDepotEntries(groupId, type, start, end)) {
            Group group = depotEntry.getGroup();
            if (!group.isCompany() && !GroupPermissionUtil.contains((PermissionChecker)permissionChecker, (long)group.getGroupId(), (String)"VIEW") && !permissionChecker.isGroupAdmin(group.getGroupId())) continue;
            filteredDepotEntries.add(depotEntry);
        }
        return filteredDepotEntries;
    }

    public int getGroupConnectedDepotEntriesCount(long groupId, int type) throws PortalException {
        if (!GroupPermissionUtil.contains((PermissionChecker)this.getPermissionChecker(), (long)groupId, (String)"VIEW")) {
            return 0;
        }
        return this.depotEntryLocalService.getGroupConnectedDepotEntriesCount(groupId, type);
    }

    public DepotEntry getGroupDepotEntry(long groupId) throws PortalException {
        DepotEntry depotEntry = this.depotEntryLocalService.getGroupDepotEntry(groupId);
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), (ClassedModel)depotEntry, "VIEW");
        return depotEntry;
    }

    public DepotEntry updateDepotEntry(long depotEntryId, Map<Locale, String> nameMap, Map<Locale, String> descriptionMap, Map<String, Boolean> depotAppCustomizationMap, UnicodeProperties typeSettingsUnicodeProperties, ServiceContext serviceContext) throws PortalException {
        this._depotEntryModelResourcePermission.check(this.getPermissionChecker(), depotEntryId, "UPDATE");
        return this.depotEntryLocalService.updateDepotEntry(depotEntryId, nameMap, descriptionMap, depotAppCustomizationMap, typeSettingsUnicodeProperties, serviceContext);
    }
}

