/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.verify;

import com.liferay.depot.internal.util.DepotRoleUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Role;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RoleLocalService;
import com.liferay.portal.verify.VerifyProcess;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={VerifyProcess.class})
public class DepotServiceVerifyProcess
extends VerifyProcess {
    @Reference
    private CompanyLocalService _companyLocalService;
    @Reference
    private Language _language;
    @Reference
    private RoleLocalService _roleLocalService;

    protected void doVerify() throws Exception {
        this._checkDepotRoleDescriptions();
    }

    private void _checkDepotRoleDescriptions() {
        this._companyLocalService.forEachCompanyId(companyId -> {
            for (String name : DepotRoleUtil.DEPOT_ROLE_NAMES) {
                Map<Locale, String> descriptionMap;
                Role role = this._roleLocalService.fetchRole(companyId.longValue(), name);
                if (role == null || Objects.equals(descriptionMap = DepotRoleUtil.getDescriptionMap(companyId, this._language, name), role.getDescriptionMap())) continue;
                role.setDescriptionMap(descriptionMap);
                this._roleLocalService.updateRole(role);
            }
        });
    }
}

