/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.depot.internal.roles.admin.role.type.contributor;

import com.liferay.portal.kernel.feature.flag.FeatureFlagManagerUtil;
import com.liferay.portal.kernel.language.Language;
import com.liferay.portal.kernel.model.Role;
import com.liferay.roles.admin.role.type.contributor.RoleTypeContributor;
import java.util.Locale;
import java.util.Objects;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"service.ranking:Integer=400"}, service={RoleTypeContributor.class})
public class DepotRoleTypeContributor
implements RoleTypeContributor {
    private static final String[] _EXCLUDED_ROLE_NAMES = new String[]{"Asset Library Owner"};
    @Reference
    private Language _language;

    public String[] getExcludedRoleNames() {
        return _EXCLUDED_ROLE_NAMES;
    }

    public String getIcon() {
        return "globe";
    }

    public String getName() {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            return "space";
        }
        return "asset-library";
    }

    public String[] getSubtypes() {
        return new String[0];
    }

    public String getTabTitle(Locale locale) {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            return this._language.get(locale, "space-roles");
        }
        return this._language.get(locale, "asset-library-roles");
    }

    public String getTitle(Locale locale) {
        if (FeatureFlagManagerUtil.isEnabled((String)"LPD-17564")) {
            return this._language.get(locale, "space-role");
        }
        return this._language.get(locale, "asset-library-role");
    }

    public int getType() {
        return 5;
    }

    public boolean isAllowAssignMembers(Role role) {
        return false;
    }

    public boolean isAllowDelete(Role role) {
        return role != null && !Objects.equals(role.getName(), "Asset Library Administrator") && !Objects.equals(role.getName(), "Asset Library Member") && !Objects.equals(role.getName(), "Asset Library Connected Site Member") && !Objects.equals(role.getName(), "Asset Library Owner");
    }

    public boolean isAutomaticallyAssigned(Role role) {
        return Objects.equals(role.getName(), "Asset Library Member") || Objects.equals(role.getName(), "Asset Library Connected Site Member");
    }
}

