/**
 * SPDX-FileCopyrightText: (c) 2025 Liferay, Inc. https://liferay.com
 * SPDX-License-Identifier: LGPL-2.1-or-later OR LicenseRef-Liferay-DXP-EULA-2.0.0-2023-06
 */

package com.liferay.depot.model.impl;

import com.liferay.depot.model.DepotEntryPin;
import com.liferay.depot.service.DepotEntryPinLocalServiceUtil;

/**
 * The extended model base implementation for the DepotEntryPin service. Represents a row in the &quot;DepotEntryPin&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This class exists only as a container for the default extended model level methods generated by ServiceBuilder. Helper methods and all application logic should be put in {@link DepotEntryPinImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see DepotEntryPinImpl
 * @see DepotEntryPin
 * @generated
 */
public abstract class DepotEntryPinBaseImpl
	extends DepotEntryPinModelImpl implements DepotEntryPin {

	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this class directly. All methods that expect a depot entry pin model instance should use the <code>DepotEntryPin</code> interface instead.
	 */
	@Override
	public void persist() {
		if (this.isNew()) {
			DepotEntryPinLocalServiceUtil.addDepotEntryPin(this);
		}
		else {
			DepotEntryPinLocalServiceUtil.updateDepotEntryPin(this);
		}
	}

}