/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.data.engine.internal.nativeobject.tracker;

import com.liferay.data.engine.nativeobject.DataEngineNativeObject;
import com.liferay.data.engine.nativeobject.tracker.DataEngineNativeObjectTracker;
import com.liferay.portal.kernel.util.StringUtil;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.osgi.service.component.annotations.ReferencePolicyOption;

@Component(immediate=true, service={DataEngineNativeObjectTracker.class})
public class DataEngineNativeObjectTrackerImpl
implements DataEngineNativeObjectTracker {
    private final Map<String, DataEngineNativeObject> _dataEngineNativeObjects = new ConcurrentHashMap<String, DataEngineNativeObject>();

    public DataEngineNativeObject getDataEngineNativeObject(String className) {
        return this._dataEngineNativeObjects.get(StringUtil.toUpperCase((String)className));
    }

    public Collection<DataEngineNativeObject> getDataEngineNativeObjects() {
        return this._dataEngineNativeObjects.values();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, policyOption=ReferencePolicyOption.GREEDY)
    protected void addDataEngineNativeObject(DataEngineNativeObject dataEngineNativeObject) throws Exception {
        this._dataEngineNativeObjects.put(StringUtil.toUpperCase((String)dataEngineNativeObject.getClassName()), dataEngineNativeObject);
    }

    protected void removeDataEngineNativeObject(DataEngineNativeObject dataEngineNativeObject) {
        this._dataEngineNativeObjects.remove(StringUtil.toUpperCase((String)dataEngineNativeObject.getClassName()));
    }
}

